package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets ErrorType
 */
public enum ErrorType {
    /**
     * Business error error type.
     */
    BUSINESS_ERROR("BUSINESS_ERROR"),
    /**
     * Technical error error type.
     */
    TECHNICAL_ERROR("TECHNICAL_ERROR");

    private String value;

    ErrorType(String value) {
        this.value = value;
    }

    /**
     * From value error type.
     *
     * @param text the text
     * @return the error type
     */
    @JsonCreator
    public static ErrorType fromValue(String text) {
        for (ErrorType b : ErrorType.values()) {
            if (String.valueOf(b.value).equals(text)) {
                return b;
            }
        }
        return null;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }
}
