/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import io.quarkus.arc.Arc;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.messaging.BusinessErrorHandlerStepService;
import org.tkit.rhpam.quarkus.messaging.ProcessClientServiceV2;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;
import org.tkit.rhpam.quarkus.process.BusinessProcess;
import org.tkit.rhpam.quarkus.process.ProcessStepService;

@ApplicationScoped
public class TkitRhpamWIHService {
    private static final Logger log = LoggerFactory.getLogger(TkitRhpamWIHService.class);
    @Inject
    ProcessClientServiceV2 processClientServiceV2;
    @Inject
    ThreadContext threadContext;
    @Inject
    ManagedExecutor managedExecutor;
    @Inject
    BusinessErrorHandlerStepService businessErrorHandlerStepService;

    @Transactional(value=Transactional.TxType.REQUIRED)
    @Acknowledgment(value=Acknowledgment.Strategy.MANUAL)
    @Incoming(value="tkitRhpamWih")
    public CompletionStage<Void> onWIHMessage(AmqpMessage<String> message) {
        if (log.isDebugEnabled()) {
            log.debug("Message properties: {}", (Object)message.getApplicationProperties());
        }
        return this.threadContext.withContextCapture(CompletableFuture.runAsync(() -> {
            ProcessStepExecution execution;
            try {
                execution = this.processClientServiceV2.startLog((Message)message);
            }
            catch (Exception e) {
                message.nack((Throwable)e);
                return;
            }
            long startTime = System.currentTimeMillis();
            log.info("Process work item {} started. Attempt: {}", (Object)execution, (Object)(message.getDeliveryCount() + 1L));
            Arc.container().requestContext().activate();
            ProcessStepService stepService = (ProcessStepService)Arc.container().instance(ProcessStepService.class, new Annotation[]{new BusinessProcess.Literal(execution.getProcessId())}).get();
            Arc.container().requestContext().deactivate();
            if (stepService == null) {
                log.error("No ProcessStepService for {}", (Object)execution.getProcessId());
                message.nack((Throwable)new IllegalArgumentException("No ProcessStepService for " + execution.getProcessId()));
                return;
            }
            try {
                ProcessStepExecutionResult result = stepService.doExecute(execution);
                this.handleStepSuccess(execution, result, message);
                message.ack();
            }
            catch (Exception e) {
                AdditionalErrorInfo additionalErrorInfo = stepService.provideErrorInformation(execution, e);
                log.error("Business execution failed for step: {} with error: ", (Object)execution.getName(), (Object)e.getMessage());
                this.handleStepFailed(execution, e, message, additionalErrorInfo);
            }
        }));
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    @Acknowledgment(value=Acknowledgment.Strategy.MANUAL)
    @Incoming(value="businessErrorWih")
    public CompletionStage<Void> onBusinessErrorWIHMessage(AmqpMessage<String> message) {
        return this.threadContext.withContextCapture(CompletableFuture.runAsync(() -> {
            ProcessStepExecution execution;
            try {
                execution = this.processClientServiceV2.startLog((Message)message);
            }
            catch (Exception e) {
                message.nack((Throwable)e);
                return;
            }
            long startTime = System.currentTimeMillis();
            log.info("Process work item {} started. Attempt: {}", (Object)execution, (Object)(message.getDeliveryCount() + 1L));
            BusinessErrorHandlerStepService stepService = this.businessErrorHandlerStepService;
            if (stepService == null) {
                log.error("No ProcessStepService for {}", (Object)execution.getProcessId());
                message.nack((Throwable)new IllegalArgumentException("No ProcessStepService for " + execution.getProcessId()));
                return;
            }
            try {
                ProcessStepExecutionResult result = stepService.doExecute(execution);
                this.handleStepSuccess(execution, result, message);
                message.ack();
            }
            catch (Exception e) {
                AdditionalErrorInfo additionalErrorInfo = stepService.provideErrorInformation(execution, e);
                log.error("Business execution failed for step: {}", (Object)execution.getName(), (Object)e);
                this.handleStepFailed(execution, e, message, additionalErrorInfo);
            }
        }));
    }

    private void handleStepFailed(ProcessStepExecution execution, Throwable t, AmqpMessage<String> message, AdditionalErrorInfo additionalErrorInfo) {
        log.info("#### handleStepFailed: {}", (Object)t.getMessage());
        try {
            this.processClientServiceV2.endLog(execution, null, message, t, additionalErrorInfo);
            message.ack();
        }
        catch (RhpamException rhe) {
            message.nack((Throwable)rhe);
        }
        catch (Exception e) {
            log.error("Error in endlog", (Throwable)e);
            message.nack((Throwable)e);
        }
        log.info("#### FINISHED handleStepFailed");
    }

    private void handleStepSuccess(ProcessStepExecution execution, ProcessStepExecutionResult processStepExecutionResult, AmqpMessage<String> message) {
        log.info("#### handleStepSuccess {}", (Object)processStepExecutionResult);
        try {
            this.processClientServiceV2.endLog(execution, processStepExecutionResult, message, null, null);
        }
        catch (Exception e) {
            log.error("Error in endlog", (Throwable)e);
        }
        log.info("### FINISH handleStepSuccess");
    }
}

