/*
 * Decompiled with CFR 0.152.
 */
package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import ext.api.centrallog.model.ErrorType;
import ext.api.centrallog.model.IncidentEvent;
import ext.api.centrallog.model.PriorityLevel;
import ext.api.centrallog.model.ResolutionOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class OpenIncidentEvent
extends IncidentEvent {
    @Valid
    private String errorCode = null;
    @Valid
    private String errorMessage = null;
    @Valid
    private ErrorType errorType = null;
    @Valid
    private String externalIssueId = null;
    @Valid
    @NotNull
    private String nodeId = null;
    @Valid
    private PriorityLevel priority = null;
    @Valid
    private List<ResolutionOption> resolutionOptions = new ArrayList<ResolutionOption>();
    @Valid
    private Integer retryCount = null;
    @Valid
    private PriorityLevel severity = null;

    public OpenIncidentEvent errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public OpenIncidentEvent errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public OpenIncidentEvent errorType(ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    @JsonProperty(value="errorType")
    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public OpenIncidentEvent externalIssueId(String externalIssueId) {
        this.externalIssueId = externalIssueId;
        return this;
    }

    @JsonProperty(value="externalIssueId")
    public String getExternalIssueId() {
        return this.externalIssueId;
    }

    public void setExternalIssueId(String externalIssueId) {
        this.externalIssueId = externalIssueId;
    }

    public OpenIncidentEvent nodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @JsonProperty(value="nodeId")
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public OpenIncidentEvent priority(PriorityLevel priority) {
        this.priority = priority;
        return this;
    }

    @JsonProperty(value="priority")
    public PriorityLevel getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityLevel priority) {
        this.priority = priority;
    }

    public OpenIncidentEvent resolutionOptions(List<ResolutionOption> resolutionOptions) {
        this.resolutionOptions = resolutionOptions;
        return this;
    }

    @JsonProperty(value="resolutionOptions")
    public List<ResolutionOption> getResolutionOptions() {
        return this.resolutionOptions;
    }

    public void setResolutionOptions(List<ResolutionOption> resolutionOptions) {
        this.resolutionOptions = resolutionOptions;
    }

    public OpenIncidentEvent retryCount(Integer retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    @JsonProperty(value="retryCount")
    public Integer getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public OpenIncidentEvent severity(PriorityLevel severity) {
        this.severity = severity;
        return this;
    }

    @JsonProperty(value="severity")
    public PriorityLevel getSeverity() {
        return this.severity;
    }

    public void setSeverity(PriorityLevel severity) {
        this.severity = severity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIncidentEvent openIncidentEvent = (OpenIncidentEvent)o;
        return Objects.equals(this.errorCode, openIncidentEvent.errorCode) && Objects.equals(this.errorMessage, openIncidentEvent.errorMessage) && Objects.equals((Object)this.errorType, (Object)openIncidentEvent.errorType) && Objects.equals(this.externalIssueId, openIncidentEvent.externalIssueId) && Objects.equals(this.nodeId, openIncidentEvent.nodeId) && Objects.equals((Object)this.priority, (Object)openIncidentEvent.priority) && Objects.equals(this.resolutionOptions, openIncidentEvent.resolutionOptions) && Objects.equals(this.retryCount, openIncidentEvent.retryCount) && Objects.equals((Object)this.severity, (Object)openIncidentEvent.severity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.errorCode, this.errorMessage, this.errorType, this.externalIssueId, this.nodeId, this.priority, this.resolutionOptions, this.retryCount, this.severity});
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIncidentEvent {\n");
        sb.append("    ").append(this.toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorType: ").append(this.toIndentedString((Object)this.errorType)).append("\n");
        sb.append("    externalIssueId: ").append(this.toIndentedString(this.externalIssueId)).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    resolutionOptions: ").append(this.toIndentedString(this.resolutionOptions)).append("\n");
        sb.append("    retryCount: ").append(this.toIndentedString(this.retryCount)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

