package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.Objects;


/**
 * The type Process end event.
 */
public class ProcessEndEvent extends ActivityEvent {
    private @Valid @NotNull
    Resolution resolution = null;

    /**
     * Resolution process end event.
     *
     * @param resolution the resolution
     * @return the process end event
     */
    public ProcessEndEvent resolution(Resolution resolution) {
        this.resolution = resolution;
        return this;
    }


    /**
     * Gets resolution.
     *
     * @return the resolution
     */
    @JsonProperty("resolution")

    public Resolution getResolution() {
        return resolution;
    }

    /**
     * Sets resolution.
     *
     * @param resolution the resolution
     */
    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProcessEndEvent processEndEvent = (ProcessEndEvent) o;
        return Objects.equals(resolution, processEndEvent.resolution);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resolution);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessEndEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    resolution: ").append(toIndentedString(resolution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
