/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.rs;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.process.RetryStepService;
import org.tkit.rhpam.quarkus.rs.model.ResolutionRequest;

@RequestScoped
@Transactional
@Path(value="/failedSteps/{stepId}/resolution")
@Tag(name="failedStepsResolutionAPI")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class FailedStepResolutionRestController {
    private static final Logger log = LoggerFactory.getLogger(FailedStepResolutionRestController.class);
    @Inject
    private RetryStepService retryStepService;

    @POST
    public Response resolveFailedStep(@PathParam(value="stepId") String failedStepId, @Parameter ResolutionRequest request) throws RhpamException {
        try {
            this.retryStepService.resolveFailedStep(failedStepId, request.getResolutionOption(), "INTERNAL_RESOLUTION");
            return Response.accepted().build();
        }
        catch (Exception e) {
            throw new RhpamException(FailedStepResolutionErrorKeys.FAILED_TO_PROCESS_RESOLUTION.name(), e);
        }
    }

    static enum FailedStepResolutionErrorKeys {
        FAILED_TO_PROCESS_RESOLUTION;

    }
}

