package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import java.util.Objects;


/**
 * The type Node end event.
 */
public class NodeEndEvent extends NodeEvent {
    private @Valid
    Resolution resolution = null;

    /**
     * Resolution node end event.
     *
     * @param resolution the resolution
     * @return the node end event
     */
    public NodeEndEvent resolution(Resolution resolution) {
        this.resolution = resolution;
        return this;
    }


    /**
     * Gets resolution.
     *
     * @return the resolution
     */
    @JsonProperty("resolution")

    public Resolution getResolution() {
        return resolution;
    }

    /**
     * Sets resolution.
     *
     * @param resolution the resolution
     */
    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NodeEndEvent nodeEndEvent = (NodeEndEvent) o;
        return Objects.equals(resolution, nodeEndEvent.resolution);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resolution);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NodeEndEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    resolution: ").append(toIndentedString(resolution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
