package org.tkit.rhpam.quarkus.domain.daos;

import org.eclipse.microprofile.opentracing.Traced;
import org.tkit.rhpam.quarkus.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.domain.models.StageFlag;

import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import java.util.Date;


/**
 * The type Domain process info dao.
 */
@ApplicationScoped
@Traced
@Transactional
public class DomainProcessInfoDAO {
    @PersistenceContext
    private EntityManager em;

    @TransactionAttribute(TransactionAttributeType.REQUIRED)
    public DomainProcessInfo selectForUpdate(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        try {
            return em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.id = :id",
                    DomainProcessInfo.class)
                    .setParameter("id", id)
                    .setLockMode(LockModeType.PESSIMISTIC_WRITE)
                    .getSingleResult();
        } catch (NoResultException nre) {
            return null;
        }
    }

    @TransactionAttribute(TransactionAttributeType.REQUIRED)
    public DomainProcessInfo selectForUpdate(String domainRefKey, String domainRefId, String processId) {
        String id = domainRefKey + "#" + domainRefId;
        try {
            return em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.id = :id AND dpi.currentProcessId = :processId",
                    DomainProcessInfo.class)
                    .setParameter("id", id)
                    .setParameter("processId", processId)
                    .setLockMode(LockModeType.PESSIMISTIC_WRITE)
                    .getSingleResult();
        } catch (NoResultException nre) {
            return null;
        }

    }

    @TransactionAttribute(TransactionAttributeType.REQUIRED)
    public DomainProcessInfo update(DomainProcessInfo toUpdate) {
        toUpdate = em.merge(toUpdate);
        em.flush();
        return toUpdate;
    }

    @TransactionAttribute(TransactionAttributeType.REQUIRED)
    public DomainProcessInfo addStageFlag(String domainRefKey, String domainRefId, String flagName, Date date, String info) {
        DomainProcessInfo dpi = this.selectForUpdate(domainRefKey, domainRefId);
        StageFlag stageFlag = new StageFlag();
        stageFlag.setDate(date);
        stageFlag.setInfo(info);
        dpi.getStageFlags().put(flagName, stageFlag);
        return this.update(dpi);
    }
}
