/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import ext.api.centrallog.api.ProcessLogEventEmitter;
import ext.api.centrallog.model.EventType;
import ext.api.centrallog.model.NodeEndEvent;
import ext.api.centrallog.model.NodeStartEvent;
import ext.api.centrallog.model.ProcessEndEvent;
import ext.api.centrallog.model.ProcessStartEvent;
import ext.api.centrallog.model.Resolution;
import io.opentracing.Tracer;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.hibernate.service.spi.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.jpa.models.AbstractTraceableEntity;
import org.tkit.rhpam.quarkus.domain.daos.DomainProcessInfoDAO;
import org.tkit.rhpam.quarkus.domain.daos.FailedStepDAO;
import org.tkit.rhpam.quarkus.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.domain.models.FailedStepSearchCriteria;
import org.tkit.rhpam.quarkus.domain.models.StageFlag;
import org.tkit.rhpam.quarkus.domain.models.enums.ProcessStepStatus;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.model.NodeType;
import org.tkit.rhpam.quarkus.messaging.model.ProcessEventItem;
import org.tkit.rhpam.quarkus.messaging.model.ProcessEventType;

@ApplicationScoped
@Traced
public class ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessEventListener.class);
    private static final String PROCESS_FAIL_ON_LAST_STEP_FAIL_ENABLED_PROPERTY = "ORG_TKIT_RHPAM_ENABLE_PROCESS_FAIL_ON_LAST_STEP_FAIL";
    @Inject
    ProcessLogEventEmitter centralEventEmitter;
    @Inject
    FailedStepDAO failedStepDAO;
    @Inject
    DomainProcessInfoDAO domainProcessInfoDAO;
    @Inject
    private Tracer configuredTracer;

    @Transactional(value=Transactional.TxType.REQUIRED)
    @Acknowledgment(value=Acknowledgment.Strategy.MANUAL)
    @Incoming(value="jms.queue.ProcessLogQueue")
    public CompletionStage<Void> onMessage(AmqpMessage<String> message) {
        return CompletableFuture.runAsync(() -> {
            try {
                ProcessEventItem logItem = this.createProcessLogItem(message);
                switch (logItem.getProcessEventType()) {
                    case PROCESS_START: {
                        this.startProcessEvent(logItem);
                        break;
                    }
                    case PROCESS_END: {
                        this.endProcessEvent(logItem);
                        break;
                    }
                    case NODE_END: {
                        this.endNodeEvent(logItem);
                        break;
                    }
                    case NODE_START: {
                        this.startNodeEvent(logItem);
                        break;
                    }
                    default: {
                        message.nack((Throwable)new IllegalArgumentException(String.format("ProcessEventType %s not known.", new Object[]{logItem.getProcessEventType()})));
                    }
                }
                message.ack();
            }
            catch (Exception ex) {
                log.error("Error execute the log item ", (Throwable)ex);
                message.nack((Throwable)ex);
            }
        });
    }

    private ProcessEventItem createProcessLogItem(AmqpMessage<String> msg) throws Exception {
        Long parentProcessInstanceId = (Long)MessageUtil.getProperty(msg, "TKIT_PARENT_PROCESS_INSTANCE_ID");
        String parentProcessId = (String)MessageUtil.getProperty(msg, "TKIT_PARENT_PROCESS_ID");
        Long subProcessId = (Long)MessageUtil.getProperty(msg, "TKIT_SUB_PROCESS_ID");
        Long processInstanceId = (Long)MessageUtil.getProperty(msg, "TKIT_PROCESS_INSTANCE_ID");
        String processId = (String)MessageUtil.getProperty(msg, "TKIT_PROCESS_ID");
        String processVersion = (String)MessageUtil.getProperty(msg, "TKIT_PROCESS_VERSION");
        String listenerType = (String)MessageUtil.getProperty(msg, "TKIT_LISTENER_TYPE");
        String nodeName = (String)MessageUtil.getProperty(msg, "TKIT_NODE_NAME");
        Long nodeId = (Long)MessageUtil.getProperty(msg, "TKIT_NODE_ID");
        String deploymentId = (String)MessageUtil.getProperty(msg, "TKIT_DEPLOYMENT_ID");
        Long referenceBid = (Long)MessageUtil.getProperty(msg, "TKIT_REFERENCE_BID");
        String referenceKey = (String)MessageUtil.getProperty(msg, "TKIT_REFERENCE_KEY");
        String processLogGuid = (String)MessageUtil.getProperty(msg, "TKIT_PROCESS_LOG_GUID");
        String processName = (String)MessageUtil.getProperty(msg, "TKIT_PROCESS_NAME");
        Long workItemId = (Long)MessageUtil.getProperty(msg, "TKIT_WORK_ITEM_ID");
        Long timerId = (Long)MessageUtil.getProperty(msg, "TKIT_TIMER_ID");
        Long executionId = (Long)MessageUtil.getProperty(msg, "TKIT_EXECUTION_ID");
        ProcessEventType processEvent = MessageUtil.getEnumProperty(msg, "TKIT_PROCESS_LOG_EVENT", ProcessEventType.class);
        NodeType nodeType = MessageUtil.getEnumProperty(msg, "TKIT_NODE_TYPE", NodeType.class);
        String body = (String)msg.getPayload();
        Map<String, Object> parameters = MessageUtil.deserializeBody(msg);
        Date executionDate = MessageUtil.getStringDateProperty(msg, "TKIT_EXECUTION_DATE", new Date());
        Boolean processCompleteError = (Boolean)MessageUtil.getProperty(msg, "PROP_PROCESS_ERROR");
        String processCompleteOutcome = (String)MessageUtil.getProperty(msg, "PROP_PROCESS_OUTCOME");
        String nodeResolutionStatus = (String)MessageUtil.getProperty(msg, "TKIT_RESOLUTION_STATUS");
        String correlationId = (String)MessageUtil.getProperty(msg, "TKIT_CORRELATION_ID");
        return ProcessEventItem.builder().nodeType(nodeType).executionId(executionId).timerId(timerId).processLogGuid(processLogGuid).body(body).processEventType(processEvent).deploymentId(deploymentId).parentProcessInstanceId(parentProcessInstanceId).parentProcessId(parentProcessId).subProcessId(subProcessId).processInstanceId(processInstanceId).processId(processId).processName(processName).processVersion(processVersion).listenerType(listenerType).executionDate(executionDate).name(nodeName).nodeId(nodeId).workItemId(workItemId).referenceKey(referenceKey).referenceBid(referenceBid).parameters(parameters).outcome(processCompleteOutcome).nodeResolutionStatus(nodeResolutionStatus).correlationId(correlationId).error(processCompleteError != null ? processCompleteError : false).build();
    }

    private void startNodeEvent(ProcessEventItem logItem) throws ServiceException, RhpamException {
        DomainProcessInfo dpi;
        NodeStartEvent event = new NodeStartEvent();
        event.setNodeId(String.valueOf(logItem.getNodeId()));
        event.setProcessEventType(EventType.NODE_START_EVENT);
        event.setExecutionId(String.valueOf(logItem.getExecutionId()));
        event.setEventTime(logItem.getExecutionDate());
        event.setCorrelationId(String.valueOf(logItem.getWorkItemId()));
        event.setProcessId(logItem.getProcessId());
        event.setProcessInstanceId(String.valueOf(logItem.getProcessInstanceId()));
        event.setBusinessRelevant(true);
        event.setNodeName(logItem.getName());
        if (logItem.getNodeType() != null) {
            switch (logItem.getNodeType()) {
                case TIMER: {
                    event.setNodeType(ext.api.centrallog.model.NodeType.TIMER);
                    break;
                }
                case EVENT: {
                    event.setNodeType(ext.api.centrallog.model.NodeType.EVENT);
                    break;
                }
                case SUB_PROCESS: {
                    event.setNodeType(ext.api.centrallog.model.NodeType.SUB_PROCESS);
                }
                case END: {
                    break;
                }
                default: {
                    event.setNodeType(ext.api.centrallog.model.NodeType.ACTIVITY);
                    log.warn("Not supported node type: {} for log item {}. Using default ACTIVITY type.", (Object)logItem.getNodeType(), (Object)logItem);
                }
            }
        }
        if ((dpi = this.domainProcessInfoDAO.selectForUpdate(logItem.getReferenceKey(), String.valueOf(logItem.getReferenceBid()))) != null && logItem.getParentProcessId() == null) {
            dpi.setCurrentProcessInstanceId(logItem.getProcessInstanceId());
            dpi.setCurrentProcessStepName(logItem.getName());
            if (dpi.getCurrentProcessStatus() == DomainProcessInfo.ProcessStatus.ERROR || dpi.getCurrentProcessStatus() == DomainProcessInfo.ProcessStatus.PENDING) {
                dpi.setCurrentProcessStatus(DomainProcessInfo.ProcessStatus.RUNNING);
            }
            dpi.setCurrentProcessStepStatus(ProcessStepStatus.IN_EXECUTION.name());
            this.domainProcessInfoDAO.update(dpi);
        }
        this.centralEventEmitter.emitProcessEvent(event);
        log.info("startNodeEvent : {}", (Object)logItem);
    }

    private void endNodeEvent(ProcessEventItem logItem) throws ServiceException, RhpamException {
        DomainProcessInfo dpi;
        NodeEndEvent event = new NodeEndEvent();
        event.setNodeId(String.valueOf(logItem.getNodeId()));
        event.setProcessEventType(EventType.NODE_END_EVENT);
        event.setExecutionId(String.valueOf(logItem.getExecutionId()));
        event.setEventTime(logItem.getExecutionDate());
        event.setCorrelationId(logItem.getCorrelationId());
        event.setProcessId(logItem.getProcessId());
        event.setProcessInstanceId(String.valueOf(logItem.getProcessInstanceId()));
        event.setBusinessRelevant(true);
        event.setVariables(logItem.getParameters());
        if (logItem.getNodeResolutionStatus() != null) {
            event.setResolution(Resolution.fromValue(logItem.getNodeResolutionStatus()));
        }
        if (logItem.getNodeType() == NodeType.SUB_PROCESS) {
            FailedStepSearchCriteria failedStepSearchCriteria = new FailedStepSearchCriteria();
            failedStepSearchCriteria.setProcessName(logItem.getName());
            failedStepSearchCriteria.setProcessInstanceId(logItem.getSubProcessId());
            failedStepSearchCriteria.setParentProcessInstanceId(String.valueOf(logItem.getProcessInstanceId()));
            List<FailedStep> fsResults = this.failedStepDAO.findBySearchCriteria(failedStepSearchCriteria);
            if (fsResults != null && fsResults.size() > 0) {
                FailedStep failedStep = fsResults.get(0);
                event.setResolution(Resolution.FAILED);
                event.getMetadata().put("subProcessId", logItem.getSubProcessId());
                event.getMetadata().put("failedStepId", failedStep.getId());
                event.getMetadata().put("failedProcessStepName", failedStep.getProcessStepName());
                event.getMetadata().put("errorCode", failedStep.getErrorCode());
                event.getMetadata().put("errorMessage", failedStep.getErrorMessage());
                FailedStep parentFailedStepCopy = new FailedStep();
                parentFailedStepCopy.setParentProcessInstanceId(logItem.getParentProcessInstanceId() != null ? String.valueOf(logItem.getParentProcessInstanceId()) : null);
                parentFailedStepCopy.setNodeId(String.valueOf(logItem.getNodeId()));
                parentFailedStepCopy.setWorkItemId(logItem.getWorkItemId() != null ? logItem.getWorkItemId() : logItem.getExecutionId());
                parentFailedStepCopy.setStatus(FailedStep.FailedStepStatus.OPEN);
                parentFailedStepCopy.setNodeName(logItem.getName());
                parentFailedStepCopy.setProcessStepName(logItem.getName());
                parentFailedStepCopy.setReferenceKey(logItem.getReferenceKey());
                parentFailedStepCopy.setReferenceBid(logItem.getReferenceBid() != null ? String.valueOf(logItem.getReferenceBid()) : null);
                parentFailedStepCopy.setExecutionCount(1);
                parentFailedStepCopy.setFailureType(failedStep.getFailureType());
                parentFailedStepCopy.setErrorCode(failedStep.getErrorCode());
                parentFailedStepCopy.setProcessInstanceId(logItem.getProcessInstanceId());
                parentFailedStepCopy.setProcessId(logItem.getProcessId());
                parentFailedStepCopy.setDeploymentId(logItem.getDeploymentId());
                parentFailedStepCopy.setErrorMessage(failedStep.getErrorMessage());
                parentFailedStepCopy.setOriginalJMSMessage(failedStep.getOriginalJMSMessage());
                parentFailedStepCopy.setHeaders(failedStep.getHeaders());
                parentFailedStepCopy.setProcessName(logItem.getProcessName());
                this.failedStepDAO.create((AbstractTraceableEntity)parentFailedStepCopy);
            }
        }
        if (logItem.getParentProcessId() == null && (dpi = this.domainProcessInfoDAO.selectForUpdate(logItem.getReferenceKey(), String.valueOf(logItem.getReferenceBid()))) != null) {
            dpi.setCurrentProcessInstanceId(logItem.getProcessInstanceId());
            dpi.setCurrentProcessStepName(logItem.getName());
            if (event.getResolution() == Resolution.FAILED) {
                dpi.setCurrentProcessStatus(DomainProcessInfo.ProcessStatus.ERROR);
                dpi.setCurrentProcessStepStatus(DomainProcessInfo.ProcessStatus.ERROR.name());
            } else {
                if (dpi.getCurrentProcessStatus() == DomainProcessInfo.ProcessStatus.ERROR) {
                    dpi.setCurrentProcessStatus(DomainProcessInfo.ProcessStatus.RUNNING);
                }
                dpi.setCurrentProcessStepStatus(ProcessStepStatus.COMPLETED.name());
            }
            this.domainProcessInfoDAO.update(dpi);
        }
        this.centralEventEmitter.emitProcessEvent(event);
    }

    private void startProcessEvent(ProcessEventItem logItem) throws ServiceException, RhpamException {
        ProcessStartEvent event = new ProcessStartEvent();
        event.setBusinessRelevant(true);
        event.setVariables(logItem.getParameters());
        event.setCorrelationId(String.valueOf(logItem.getProcessInstanceId()));
        event.setEventTime(new Date());
        String executionId = logItem.getProcessLogGuid() != null ? logItem.getProcessLogGuid() : String.valueOf(logItem.getProcessInstanceId());
        event.setExecutionId(executionId);
        event.getMetadata().put("nodeId", logItem.getNodeId());
        event.getMetadata().put("TENANT_ID", logItem.getParameters().get("TENANT_ID"));
        event.getMetadata().put("TENANT_LOCATION_ID", logItem.getParameters().get("TENANT_LOCATION_ID"));
        event.setProcessEventType(EventType.PROCESS_START_EVENT);
        event.setProcessId(logItem.getProcessId());
        event.setProcessInstanceId("" + logItem.getProcessInstanceId());
        event.setBusinessKey("" + logItem.getReferenceBid());
        event.setBusinessKeyType(logItem.getReferenceKey());
        event.setDeploymentId(logItem.getDeploymentId());
        event.setParentProcessInstanceId("" + logItem.getParentProcessInstanceId());
        event.setParentProcessId(logItem.getParentProcessId());
        event.setProcessName(logItem.getProcessName());
        event.setProcessVersion(logItem.getProcessVersion());
        DomainProcessInfo dpi = this.domainProcessInfoDAO.selectForUpdate(event.getBusinessKeyType(), event.getBusinessKey());
        if (dpi != null) {
            if (logItem.getParentProcessInstanceId() > 0L) {
                dpi.setCurrentProcessInstanceId(logItem.getProcessInstanceId());
                dpi.setCurrentProcessStatus(DomainProcessInfo.ProcessStatus.RUNNING);
            }
            StageFlag sf = new StageFlag();
            sf.setStatus(DomainProcessInfo.ProcessStatus.RUNNING);
            sf.setDate(new Date());
            sf.setInfo("" + logItem.getProcessInstanceId());
            dpi.getStageFlags().put(logItem.getProcessId(), sf);
            this.domainProcessInfoDAO.update(dpi);
        }
        this.centralEventEmitter.emitProcessEvent(event);
    }

    private void endProcessEvent(ProcessEventItem logItem) throws ServiceException, RhpamException {
        DomainProcessInfo dpi;
        ProcessEndEvent event = new ProcessEndEvent();
        event.setBusinessRelevant(true);
        event.setVariables(logItem.getParameters());
        event.setCorrelationId(String.valueOf(logItem.getProcessInstanceId()));
        event.setEventTime(new Date());
        String executionId = logItem.getProcessLogGuid() != null ? logItem.getProcessLogGuid() : String.valueOf(logItem.getProcessInstanceId());
        event.setExecutionId(executionId);
        event.setProcessEventType(EventType.PROCESS_END_EVENT);
        event.setProcessId(logItem.getProcessId());
        event.setProcessInstanceId("" + logItem.getProcessInstanceId());
        event.setResolution(logItem.isError() ? Resolution.FAILED : Resolution.SUCCESSFUL);
        event.getMetadata().put("outcome", logItem.getOutcome());
        if (Boolean.parseBoolean(System.getenv(PROCESS_FAIL_ON_LAST_STEP_FAIL_ENABLED_PROPERTY))) {
            FailedStepSearchCriteria criteria = new FailedStepSearchCriteria();
            criteria.setProcessName(logItem.getProcessName());
            criteria.setStatus(FailedStep.FailedStepStatus.OPEN);
            criteria.setProcessInstanceId(logItem.getProcessInstanceId());
            List<FailedStep> failedStepList = this.failedStepDAO.findBySearchCriteria(criteria);
            if (failedStepList != null && failedStepList.size() == 1) {
                FailedStep failedStep = failedStepList.get(0);
                log.info("There is an active FailedStep for this process, marking it as FAILED");
                event.setResolution(Resolution.FAILED);
                event.getMetadata().put("failedStepId", failedStep.getId());
                event.getMetadata().put("failedProcessStepName", failedStep.getProcessStepName());
                event.getMetadata().put("errorCode", failedStep.getErrorCode());
                event.getMetadata().put("errorMessage", failedStep.getErrorMessage());
            }
        }
        if ((dpi = this.domainProcessInfoDAO.selectForUpdate(logItem.getReferenceKey(), String.valueOf(logItem.getReferenceBid()))) != null) {
            if (logItem.getParentProcessInstanceId() > 0L) {
                dpi.setCurrentProcessStatus(DomainProcessInfo.ProcessStatus.COMPLETED);
                dpi.setProcessActive(false);
            }
            StageFlag sf = new StageFlag();
            sf.setStatus(event.getResolution() == Resolution.FAILED ? DomainProcessInfo.ProcessStatus.ERROR : DomainProcessInfo.ProcessStatus.COMPLETED);
            sf.setDate(new Date());
            sf.setInfo("" + logItem.getProcessInstanceId());
            dpi.getStageFlags().put(logItem.getProcessId(), sf);
            this.domainProcessInfoDAO.update(dpi);
        }
        this.centralEventEmitter.emitProcessEvent(event);
    }
}

