/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.domain.daos.DomainProcessInfoDAO;
import org.tkit.rhpam.quarkus.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.messaging.FailedStepService;

@Transactional
@ApplicationScoped
@Traced
public class TechnicalErrorFailedStepListener {
    private static final Logger log = LoggerFactory.getLogger(TechnicalErrorFailedStepListener.class);
    @Inject
    private FailedStepService service;
    @Inject
    ThreadContext threadContext;
    @Inject
    private DomainProcessInfoDAO domainProcessInfoDAO;

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    @Acknowledgment(value=Acknowledgment.Strategy.MANUAL)
    @Incoming(value="tkitRhpamFailedSteps")
    public CompletionStage<Void> onFailedStepMessage(AmqpMessage<String> message) {
        return this.threadContext.withContextCapture(CompletableFuture.runAsync(() -> {
            try {
                FailedStep failedStep = this.service.createOrUpdateFailedStep((Message<String>)message);
                this.service.emitFailedStepEvent(failedStep);
                DomainProcessInfo dpi = this.domainProcessInfoDAO.selectForUpdate(failedStep.getReferenceKey(), String.valueOf(failedStep.getReferenceBid()));
                if (dpi != null) {
                    dpi.setCurrentProcessStepStatus(DomainProcessInfo.ProcessStatus.ERROR.name());
                    dpi.setCurrentProcessStatus(DomainProcessInfo.ProcessStatus.ERROR);
                    dpi.setCurrentProcessStepName(failedStep.getProcessStepName());
                    this.domainProcessInfoDAO.update(dpi);
                }
                message.ack();
            }
            catch (Exception e) {
                message.nack((Throwable)e);
            }
        }));
    }
}

