/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging.emitters;

import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.IncomingAmqpMetadata;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import java.io.IOException;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;

@ApplicationScoped
@Traced
public class FailedStepEmitter {
    @Inject
    @Channel(value="tkitRhpamFailedStepsOutgoing")
    Emitter<String> emitter;

    public void sendToFailedStepQueue(AmqpMessage<String> message, Map<String, Object> messageBody, AdditionalErrorInfo additionalErrorInfo, String errorCode) throws IOException {
        OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withApplicationProperties(message.getApplicationProperties()).withApplicationProperty("TKIT_FAILED_STEP", (Object)true).build();
        Message toEmit = messageBody != null ? Message.of((Object)MessageUtil.serializeBody(messageBody)) : Message.of((Object)((String)message.getPayload()));
        toEmit = toEmit.addMetadata((Object)meta);
        System.out.println("I am emitting a message " + message.getClass() + " with metadata: " + message.getMetadata() + " amqp inc meta? " + message.getMetadata(IncomingAmqpMetadata.class).isPresent() + " amqp out meta: " + message.getMetadata(OutgoingAmqpMetadata.class).isPresent());
        this.emitter.send(toEmit);
    }
}

