/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging.emitters;

import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.model.CommandType;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;

@ApplicationScoped
@Traced
public class JbpmMessageEmitter {
    @Inject
    @Channel(value="jms.queue.ResponseExecutionQueue")
    Emitter<String> emitter;

    public void notifyJBPM(ProcessStepExecution execution, AmqpMessage<String> message, ProcessStepExecutionResult result) throws IOException {
        result.getParameters().put("TKIT_RESOLUTION_STATUS", result.getStatus().name());
        result.getParameters().put("TKIT_CORRELATION_ID", execution.getCorrelationId());
        OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withApplicationProperties(message.getApplicationProperties()).withApplicationProperty("TKIT_CMD", (Object)CommandType.COMPLETE_WORK_ITEM.name()).build();
        Message toEmit = Message.of((Object)MessageUtil.serializeBody(result.getParameters()));
        toEmit = toEmit.addMetadata((Object)meta);
        this.emitter.send(toEmit);
    }
}

