package org.tkit.rhpam.quarkus.messaging.emitters;


import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;


/**
 * The type Failed step emitter.
 */
@ApplicationScoped
@Traced
public class FailedStepEmitter {
    /**
     * The Emitter.
     */
    @Inject
    @Channel("tkitRhpamFailedStepsOutgoing")
    Emitter<String> emitter;

    /**
     * Send to failed step queue.
     *
     * @param message             the message
     * @param messageBody         the message body
     * @param additionalErrorInfo the additional error info
     * @param errorCode           the error code
     * @throws IOException the io exception
     */
    public void sendToFailedStepQueue(AmqpMessage<String> message, Map<String, Object> messageBody, AdditionalErrorInfo additionalErrorInfo,
                                      String errorCode) throws IOException {

        OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder()
                .withApplicationProperties(message.getApplicationProperties())
                .withApplicationProperty("TKIT_FAILED_STEP", true)
                .build();
        Message<String> toEmit;
        String payload = null;
        if (messageBody != null) {
            payload = MessageUtil.serializeBody(messageBody);
        } else {
            payload = message.getPayload();
        }
        //amqp messages cant have empty body
        if (payload == null || payload.isBlank()) {
            payload = MessageUtil.serializeBody(new HashMap<>());
        }
        toEmit = Message.of(payload).addMetadata(meta);
        emitter.send(toEmit);

    }


}
