/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.process;

import ext.api.centrallog.model.EventType;
import ext.api.centrallog.model.MessageEvent;
import ext.api.centrallog.model.Severity;
import java.util.Date;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;

public class MessageFactory {
    private MessageFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static MessageEvent createMessage(ProcessStepExecution workItem, String message, Severity msgType) {
        MessageEvent msg = new MessageEvent();
        msg.setProcessId(workItem.getProcessId());
        msg.setNodeId(workItem.getNodeId());
        msg.setProcessInstanceId(String.valueOf(workItem.getProcessInstanceId()));
        msg.setCorrelationId(workItem.getCorrelationId());
        msg.setExecutionId(String.valueOf(workItem.getWorkItemId()));
        msg.setEventTime(new Date());
        msg.setMessageKey(message);
        msg.setSeverity(msgType);
        msg.setProcessEventType(EventType.MESSAGE_EVENT);
        msg.setDescription(message);
        return msg;
    }

    public static MessageEvent createErrMessageForStep(ProcessStepExecution stepLog) {
        return MessageFactory.createMessageForStep(stepLog, Severity.ERROR);
    }

    public static MessageEvent createInfoMessageForStep(ProcessStepExecution stepLog) {
        return MessageFactory.createMessageForStep(stepLog, Severity.INFO);
    }

    public static MessageEvent createMessageForStep(ProcessStepExecution workItem, Severity type) {
        return MessageFactory.createMessage(workItem, null, type);
    }
}

