/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.tracing;

import io.jaegertracing.internal.JaegerSpanContext;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.tracing.TraceFromMessage;
import org.tkit.rhpam.quarkus.tracing.TracingUtils;

@TraceFromMessage
@Interceptor
@Priority(value=1001)
public class TraceFromMessageInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TraceFromMessageInterceptor.class);
    private static final String TRACE_ID = "traceId";
    private static final String SPAN_ID = "spanId";
    private static final String PARENT_ID = "parentId";
    private static final String SAMPLED = "sampled";
    @Inject
    Tracer tracer;

    @AroundInvoke
    public Object aroundTraceIdFromMessage(InvocationContext ctx) throws Exception {
        Object[] parameters = ctx.getParameters();
        if (parameters.length > 0 && parameters[0] instanceof AmqpMessage && ctx.getMethod().getReturnType().equals(CompletionStage.class)) {
            Object object;
            block9: {
                Span span = TracingUtils.buildChildSpan(ctx.getMethod().getName(), ((AmqpMessage)parameters[0]).getApplicationProperties(), this.tracer);
                span.setTag("amqp.address", ((AmqpMessage)parameters[0]).getAddress());
                span.setTag("class", ctx.getMethod().getDeclaringClass().getName());
                span.setTag("component", "tkit-rhpam-client");
                this.putContext((JaegerSpanContext)span.context());
                Scope scope = this.tracer.scopeManager().activate(span, false);
                try {
                    Object returnValue = ctx.proceed();
                    this.clearMDCScope();
                    scope.close();
                    ((CompletionStage)returnValue).thenRun(() -> {
                        this.tracer.scopeManager().active().close();
                        span.finish();
                    });
                    object = returnValue;
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.clearMDCScope();
                        throw e;
                    }
                }
                scope.close();
            }
            return object;
        }
        log.warn("### AMQP trace interceptor called on method without amq message param {}", ctx.getParameters());
        return ctx.proceed();
    }

    protected void putContext(JaegerSpanContext spanContext) {
        MDC.put((String)TRACE_ID, (Object)spanContext.getTraceId());
        MDC.put((String)SPAN_ID, (Object)Long.toHexString(spanContext.getSpanId()));
        MDC.put((String)PARENT_ID, (Object)Long.toHexString(spanContext.getParentId()));
        MDC.put((String)SAMPLED, (Object)Boolean.toString(spanContext.isSampled()));
    }

    protected void clearMDCScope() {
        MDC.remove((String)TRACE_ID);
        MDC.remove((String)SPAN_ID);
        MDC.remove((String)PARENT_ID);
        MDC.remove((String)SAMPLED);
    }
}

