package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets ResolutionStatus
 */
public enum ResolutionStatus {
    /**
     * Resolved resolution status.
     */
    RESOLVED("RESOLVED"),
    /**
     * Deleted resolution status.
     */
    DELETED("DELETED");

    private String value;

    ResolutionStatus(String value) {
        this.value = value;
    }

    /**
     * From value resolution status.
     *
     * @param text the text
     * @return the resolution status
     */
    @JsonCreator
    public static ResolutionStatus fromValue(String text) {
        for (ResolutionStatus b : ResolutionStatus.values()) {
            if (String.valueOf(b.value).equals(text)) {
                return b;
            }
        }
        return null;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }
}
