package org.tkit.rhpam.quarkus.messaging.common;

import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * The type Exception util.
 */
@Slf4j
public class ExceptionUtil {

    /**
     * Gets exception stack trace.
     *
     * @param ex the ex
     * @return the exception stack trace
     */
    public static String getExceptionStackTrace(Throwable ex) {
        if (ex != null) {
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw)) {
                ex.printStackTrace(pw);
                return sw.toString();
            } catch (IOException er) {
                log.error("Error write stack trace to execution log", er);
            }
        }
        return null;
    }
}
