/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import ext.api.centrallog.api.ProcessLogEventEmitter;
import ext.api.centrallog.model.ErrorType;
import ext.api.centrallog.model.EventType;
import ext.api.centrallog.model.OpenIncidentEvent;
import ext.api.centrallog.model.PriorityLevel;
import ext.api.centrallog.model.ResolutionOption;
import io.smallrye.reactive.messaging.amqp.IncomingAmqpMetadata;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.hibernate.service.spi.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.jpa.models.AbstractTraceableEntity;
import org.tkit.rhpam.quarkus.domain.daos.FailedStepDAO;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.domain.models.FailedStepSearchCriteria;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;

@ApplicationScoped
@Traced
public class FailedStepService {
    private static final Logger log = LoggerFactory.getLogger(FailedStepService.class);
    private static final String SUPPORT_TOOL_CALLBACK_URL_PROPERTY = "ORG_TKIT_RHPAM_SUPPORT_TOOL_CALLBACK_URL";
    @Inject
    ProcessLogEventEmitter centralLogEmitter;
    @Inject
    FailedStepDAO service;
    @ConfigProperty(name="quarkus.resteasy.path")
    private String contextPath;

    public FailedStep createOrUpdateFailedStep(Message<String> message) throws ServiceException {
        try {
            FailedStep failedStep = this.getExistingFailedStep(message);
            if (failedStep != null) {
                failedStep.setStatus(FailedStep.FailedStepStatus.OPEN);
                failedStep.setExecutionCount(failedStep.getExecutionCount() + 1);
                failedStep = (FailedStep)this.service.update((AbstractTraceableEntity)failedStep);
            } else {
                failedStep = this.constructFailedStepFromMessage(message);
                failedStep = (FailedStep)this.service.create((AbstractTraceableEntity)failedStep);
            }
            return failedStep;
        }
        catch (Exception e) {
            throw new IllegalStateException(FailedStepServiceErrorKeys.FAILED_TO_CREATE_FAILED_STEP.name(), e);
        }
    }

    public void emitFailedStepEvent(FailedStep failedStep) throws RhpamException {
        String[] optionArr;
        OpenIncidentEvent event = new OpenIncidentEvent();
        event.setErrorCode(failedStep.getErrorCode());
        event.setErrorMessage(failedStep.getErrorMessage());
        event.setErrorType(ErrorType.fromValue(failedStep.getFailureType().name()));
        event.setNodeId(failedStep.getNodeId());
        event.setExternalIssueId(failedStep.getExternalIssueId());
        event.setPriority(PriorityLevel.HIGH);
        ArrayList<ResolutionOption> options = new ArrayList<ResolutionOption>();
        for (String item : optionArr = failedStep.getResolutionOptionsString().split(",")) {
            options.add(new ResolutionOption().key(item).label(item).callBackUrl(this.constructResolutionCallbackUrlForCentralLog(failedStep.getId())));
        }
        event.setResolutionOptions(options);
        event.setRetryCount(failedStep.getExecutionCount());
        event.setCorrelationId(failedStep.getId());
        event.setEventTime(failedStep.getModificationDate());
        event.setIncidentId(failedStep.getId());
        event.setProcessEventType(EventType.OPEN_INCIDENT_EVENT);
        event.setProcessId(failedStep.getProcessId());
        event.setProcessInstanceId(String.valueOf(failedStep.getProcessInstanceId()));
        event.setExecutionId(String.valueOf(failedStep.getWorkItemId()));
        event.getMetadata().put("deepLink", failedStep.getDeepLink());
        event.getMetadata().put("deploymentId", failedStep.getDeploymentId());
        event.getMetadata().put("referenceKey", failedStep.getReferenceKey());
        event.getMetadata().put("referenceBid", failedStep.getReferenceBid());
        event.getMetadata().put("processStepName", failedStep.getProcessStepName());
        this.centralLogEmitter.emitProcessEvent(event);
    }

    public FailedStep createOrUpdateBusinessFailedStep(ProcessStepExecution workItem, ProcessStepExecutionResult executionResult) throws IOException {
        FailedStep failedStep = null;
        FailedStepSearchCriteria criteria = new FailedStepSearchCriteria();
        criteria.setFailureType(FailedStep.FailureType.BUSINESS_ERROR);
        criteria.setProcessStepName(workItem.getName());
        criteria.setProcessInstanceId(workItem.getProcessInstanceId());
        List<FailedStep> failedStepList = this.service.findBySearchCriteria(criteria);
        if (failedStepList != null && failedStepList.size() == 1) {
            failedStep = failedStepList.get(0);
            failedStep.setExecutionCount(failedStep.getExecutionCount() + 1);
            failedStep.setStatus(FailedStep.FailedStepStatus.OPEN);
            failedStep.setWorkItemId(workItem.getWorkItemId());
            return (FailedStep)this.service.update((AbstractTraceableEntity)failedStep);
        }
        failedStep = new FailedStep();
        failedStep.setFailureType(FailedStep.FailureType.BUSINESS_ERROR);
        failedStep.setExecutionCount(1);
        failedStep.setProcessInstanceId(workItem.getProcessInstanceId());
        if (executionResult.getParameters().get("FAILED_STEP_ERROR_CODE") != null) {
            failedStep.setErrorCode((String)executionResult.getParameters().get("FAILED_STEP_ERROR_CODE"));
        }
        if (executionResult.getParameters().get("FAILED_STEP_ERROR_MSG") != null) {
            failedStep.setErrorMessage((String)executionResult.getParameters().get("FAILED_STEP_ERROR_MSG"));
        }
        if (executionResult.getParameters().get("FAILED_STEP_DEEP_LINK") != null) {
            failedStep.setDeepLink((String)executionResult.getParameters().get("FAILED_STEP_DEEP_LINK"));
        }
        failedStep.setNodeId(workItem.getNodeId());
        failedStep.setNodeName(workItem.getName());
        failedStep.setProcessId(workItem.getProcessId());
        failedStep.setProcessInstanceId(workItem.getProcessInstanceId());
        failedStep.setParentProcessInstanceId(workItem.getParentProcessInstanceId() != null ? String.valueOf(workItem.getParentProcessInstanceId()) : null);
        failedStep.setProcessStepName(workItem.getName());
        failedStep.setProcessName(workItem.getProcessName());
        failedStep.setStatus(FailedStep.FailedStepStatus.OPEN);
        failedStep.setWorkItemId(workItem.getWorkItemId());
        failedStep.setReferenceBid(workItem.getReferenceId());
        failedStep.setReferenceKey(workItem.getReferenceKey());
        failedStep.setDeploymentId(workItem.getDeploymentId());
        failedStep.setOriginalJMSMessage(MessageUtil.serializeBody(executionResult.getParameters()));
        return (FailedStep)this.service.create((AbstractTraceableEntity)failedStep);
    }

    public FailedStep updateFailedStep(ProcessStepExecution workItem, String referencedStepName, String resolutionOptions, String resolutionSignalId) throws ServiceException {
        FailedStep failedStep = null;
        FailedStepSearchCriteria criteria = new FailedStepSearchCriteria();
        criteria.setFailureType(FailedStep.FailureType.BUSINESS_ERROR);
        criteria.setProcessStepName(referencedStepName);
        criteria.setProcessInstanceId(workItem.getProcessInstanceId());
        List<FailedStep> failedStepList = this.service.findBySearchCriteria(criteria);
        if (failedStepList == null || failedStepList.size() != 1) {
            throw new IllegalArgumentException("Business error handler invoked but no matching failed step found! Step: " + referencedStepName);
        }
        failedStep = failedStepList.get(0);
        failedStep.setResolutionOptionsString(resolutionOptions);
        failedStep.setResolutionSignalReceiver(resolutionSignalId);
        failedStep = (FailedStep)this.service.update((AbstractTraceableEntity)failedStep);
        return failedStep;
    }

    private FailedStep getExistingFailedStep(Message msg) {
        FailedStep failedStep = null;
        try {
            Long workItemId = (Long)MessageUtil.getProperty(msg, "TKIT_WORK_ITEM_ID");
            FailedStepSearchCriteria criteria = new FailedStepSearchCriteria();
            criteria.setWorkItemId(workItemId);
            List<FailedStep> list = this.service.findBySearchCriteria(criteria);
        }
        catch (Exception e) {
            log.error("Error to load failed step object.", (Throwable)e);
        }
        return failedStep;
    }

    private FailedStep constructFailedStepFromMessage(Message<String> msg) {
        FailedStep failedStep = null;
        try {
            failedStep = new FailedStep();
            Long processInstanceId = (Long)MessageUtil.getProperty(msg, "TKIT_PROCESS_INSTANCE_ID");
            Long workItemId = (Long)MessageUtil.getProperty(msg, "TKIT_WORK_ITEM_ID");
            String processId = (String)MessageUtil.getProperty(msg, "TKIT_PROCESS_ID");
            Long referenceId = (Long)MessageUtil.getProperty(msg, "TKIT_REFERENCE_BID");
            String referenceKey = (String)MessageUtil.getProperty(msg, "TKIT_REFERENCE_KEY");
            String processName = (String)MessageUtil.getProperty(msg, "TKIT_PROCESS_NAME");
            String nodeName = (String)MessageUtil.getProperty(msg, "TKIT_NODE_NAME");
            Long nodeId = (Long)MessageUtil.getProperty(msg, "TKIT_NODE_ID");
            failedStep.setNodeId(String.valueOf(nodeId));
            failedStep.setOriginalJMSMessage((String)msg.getPayload());
            failedStep.setHeaders(this.createHeadersText(msg));
            failedStep.setProcessInstanceId(processInstanceId);
            failedStep.setProcessId(processId);
            failedStep.setProcessName(processName);
            failedStep.setProcessStepName(nodeName);
            failedStep.setErrorCode((String)MessageUtil.getProperty(msg, "TKIT_FS_ERROR_CODE"));
            failedStep.setErrorMessage((String)MessageUtil.getProperty(msg, "TKIT_FS_ERROR_MSG"));
            failedStep.setDeepLink((String)MessageUtil.getProperty(msg, "TKIT_FS_DEEP_LINK"));
            failedStep.setReferenceBid("" + referenceId);
            failedStep.setReferenceKey(referenceKey);
            failedStep.setWorkItemId(workItemId);
            failedStep.setExecutionCount(0);
            failedStep.setResolutionOptionsString("RETRY");
            failedStep.setStatus(FailedStep.FailedStepStatus.OPEN);
            failedStep.setFailureType(FailedStep.FailureType.TECHNICAL_ERROR);
        }
        catch (Exception e) {
            log.error("Error creating the failed step object.", (Throwable)e);
        }
        return failedStep;
    }

    private String createHeadersText(Message<String> message) {
        String headerText = null;
        HashMap<String, Object> result = new HashMap();
        try {
            JsonObject properties = ((IncomingAmqpMetadata)message.getMetadata(IncomingAmqpMetadata.class).get()).getProperties();
            result = properties.getMap();
            headerText = MessageUtil.serializeBody(result);
        }
        catch (Exception e) {
            log.error("Error serializing the header parameters of a message.", (Throwable)e);
        }
        return headerText;
    }

    private String constructResolutionCallbackUrlForCentralLog(String failedStepId) {
        StringBuilder urlBuilder = new StringBuilder();
        String callbackURlFromEnv = System.getenv(SUPPORT_TOOL_CALLBACK_URL_PROPERTY);
        if (callbackURlFromEnv != null) {
            urlBuilder.append(callbackURlFromEnv);
        } else {
            String appName = System.getenv("TKIT_SERVICE_NAME");
            appName = appName != null ? appName : "UNKNOWN";
            urlBuilder.append("http://");
            urlBuilder.append(appName);
        }
        urlBuilder.append(this.contextPath);
        urlBuilder.append("/failedSteps/");
        urlBuilder.append(failedStepId);
        urlBuilder.append("/resolution");
        return urlBuilder.toString();
    }

    public static enum FailedStepServiceErrorKeys {
        FAILED_TO_CREATE_FAILED_STEP;

    }
}

