/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.process;

import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.jpa.models.AbstractTraceableEntity;
import org.tkit.rhpam.quarkus.domain.daos.FailedStepDAO;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.process.ProcessService;

@ApplicationScoped
@Transactional
@Traced
public class RetryStepService {
    private static final Logger log = LoggerFactory.getLogger(RetryStepService.class);
    @Inject
    @Channel(value="tkitRhpamWihOutgoing")
    Emitter<String> emitter;
    @Inject
    private FailedStepDAO failedStepDAO;
    @Inject
    private ProcessService processService;
    private static final String ORIG_QUEUE = "ORIG_QUEUE";

    public void resolveFailedStep(String failedStepId, String resolutionOption, String source) throws Exception {
        FailedStep failedStep = (FailedStep)this.failedStepDAO.findById(failedStepId);
        if (failedStep == null) {
            throw new RhpamException(RetryServiceErrorKeys.FAILED_STEP_NOT_FOUND.name());
        }
        if (resolutionOption == null) {
            throw new RhpamException(RetryServiceErrorKeys.MISSING_RESOLUTION_OPTION.name());
        }
        HashSet<String> allowedResolutionOptions = new HashSet<String>();
        if (failedStep.getResolutionOptionsString() != null) {
            String[] optionArr;
            for (String item : optionArr = failedStep.getResolutionOptionsString().split(",")) {
                allowedResolutionOptions.add(item.trim().toLowerCase());
            }
        }
        if (!allowedResolutionOptions.contains((resolutionOption = resolutionOption.trim()).toLowerCase())) {
            log.error("Invalid resolution option received {}", (Object)resolutionOption);
            StringBuilder sb = new StringBuilder();
            sb.append(RetryServiceErrorKeys.INVALID_RESOLUTION_OPTIONS.name());
            sb.append(" option: '");
            sb.append(resolutionOption);
            sb.append("' is not one of allowed options: ");
            sb.append(allowedResolutionOptions);
            throw new RhpamException(sb.toString());
        }
        if (failedStep.getFailureType() == FailedStep.FailureType.BUSINESS_ERROR) {
            this.handleBusinessErrorResolution(failedStep, resolutionOption, source);
        } else {
            this.handleTechnicalErrorResolution(failedStep, resolutionOption, source);
        }
    }

    private void handleBusinessErrorResolution(FailedStep failedStep, String resolutionOption, String source) throws RhpamException {
        try {
            String signalTarget = failedStep.getResolutionSignalReceiver();
            this.processService.sendMessage(failedStep.getDeploymentId(), failedStep.getProcessInstanceId(), signalTarget, resolutionOption);
            this.updateFailedStepAndMessages(failedStep, resolutionOption, source);
        }
        catch (Exception e) {
            throw new RhpamException(RetryServiceErrorKeys.FAILED_TO_PROCESS_BUSINESS_ERR_RESOLUTION.name(), e);
        }
    }

    private void handleTechnicalErrorResolution(FailedStep failedStep, String resolutionOption, String source) throws RhpamException {
        try {
            this.emitter.send(this.recreateMessageFromFailedStep(failedStep));
            failedStep.setExecutionCount(failedStep.getExecutionCount() + 1);
            this.updateFailedStepAndMessages(failedStep, resolutionOption, source);
        }
        catch (Exception e) {
            throw new RhpamException(RetryServiceErrorKeys.FAILED_TO_PROCESS_FATAL_ERR_RESOLUTION.name(), e);
        }
    }

    private void updateFailedStepAndMessages(FailedStep failedStep, String resolutionOption, String source) throws RhpamException {
        failedStep.setStatus(FailedStep.FailedStepStatus.CLOSED);
        failedStep.setResolution(resolutionOption);
        failedStep.setResolutionOrigin(source);
        this.failedStepDAO.update((AbstractTraceableEntity)failedStep);
    }

    private Message<String> recreateMessageFromFailedStep(FailedStep failedStep) {
        Message recoveryMessage = Message.of((Object)failedStep.getOriginalJMSMessage());
        Map headersMap = (Map)MessageUtil.deserialize(failedStep.getHeaders());
        JsonObject jsonHeaders = JsonObject.mapFrom((Object)headersMap);
        String origQueue = jsonHeaders.getString(ORIG_QUEUE);
        OutgoingAmqpMetadata meta = origQueue != null ? OutgoingAmqpMetadata.builder().withApplicationProperties(jsonHeaders).withAddress(origQueue).build() : OutgoingAmqpMetadata.builder().withApplicationProperties(jsonHeaders).build();
        recoveryMessage = recoveryMessage.addMetadata((Object)meta);
        if (log.isDebugEnabled()) {
            log.debug("Emitting recovery message: {}", (Object)meta.getProperties());
        }
        return recoveryMessage;
    }

    static enum RetryServiceErrorKeys {
        FAILED_STEP_NOT_FOUND,
        MISSING_RESOLUTION_OPTION,
        INVALID_RESOLUTION_OPTIONS,
        FAILED_TO_PROCESS_BUSINESS_ERR_RESOLUTION,
        FAILED_TO_PROCESS_FATAL_ERR_RESOLUTION;

    }
}

