/*
 * Decompiled with CFR 0.152.
 */
package ext.api.centrallog.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import ext.api.centrallog.api.CentralLogObjectMapper;
import ext.api.centrallog.model.MessageEvent;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
@Transactional
public class ProcessMessageEventEmitter {
    @Inject
    @Channel(value="jms.queue.process-log-events")
    Emitter<String> emitter;

    public void emitProcessMessageEvent(@Valid MessageEvent event) throws JsonProcessingException {
        String eventPayload = CentralLogObjectMapper.writer.writeValueAsString((Object)event);
        this.emitter.send(Message.of((Object)eventPayload));
    }

    static enum ErrorCodes {
        FAILED_TO_EMIT_MSG_EVENT;

    }
}

