/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.domain.models;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.tkit.rhpam.quarkus.domain.models.StageFlag;

@Entity
@Table(name="pl_domain_process_info")
public class DomainProcessInfo {
    @Id
    private String id;
    private boolean processActive;
    private String currentProcessId;
    private Long currentProcessInstanceId;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date currentProcessStartTime;
    @Enumerated(value=EnumType.STRING)
    private ProcessStatus currentProcessStatus;
    private String currentProcessInitiator;
    private String currentProcessStepName;
    private String currentProcessStepStatus;
    @ElementCollection(fetch=FetchType.LAZY)
    @MapKeyColumn(name="stage")
    @CollectionTable(name="pl_process_stages", joinColumns={@JoinColumn(name="process_info_id")})
    private Map<String, StageFlag> stageFlags = new HashMap<String, StageFlag>();

    public DomainProcessInfo() {
    }

    public DomainProcessInfo(String domainRefKey, String domainRefId) {
        this.id = domainRefKey + "#" + domainRefId;
    }

    public String getId() {
        return this.id;
    }

    public boolean isProcessActive() {
        return this.processActive;
    }

    public String getCurrentProcessId() {
        return this.currentProcessId;
    }

    public Long getCurrentProcessInstanceId() {
        return this.currentProcessInstanceId;
    }

    public Date getCurrentProcessStartTime() {
        return this.currentProcessStartTime;
    }

    public ProcessStatus getCurrentProcessStatus() {
        return this.currentProcessStatus;
    }

    public String getCurrentProcessInitiator() {
        return this.currentProcessInitiator;
    }

    public String getCurrentProcessStepName() {
        return this.currentProcessStepName;
    }

    public String getCurrentProcessStepStatus() {
        return this.currentProcessStepStatus;
    }

    public Map<String, StageFlag> getStageFlags() {
        return this.stageFlags;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProcessActive(boolean processActive) {
        this.processActive = processActive;
    }

    public void setCurrentProcessId(String currentProcessId) {
        this.currentProcessId = currentProcessId;
    }

    public void setCurrentProcessInstanceId(Long currentProcessInstanceId) {
        this.currentProcessInstanceId = currentProcessInstanceId;
    }

    public void setCurrentProcessStartTime(Date currentProcessStartTime) {
        this.currentProcessStartTime = currentProcessStartTime;
    }

    public void setCurrentProcessStatus(ProcessStatus currentProcessStatus) {
        this.currentProcessStatus = currentProcessStatus;
    }

    public void setCurrentProcessInitiator(String currentProcessInitiator) {
        this.currentProcessInitiator = currentProcessInitiator;
    }

    public void setCurrentProcessStepName(String currentProcessStepName) {
        this.currentProcessStepName = currentProcessStepName;
    }

    public void setCurrentProcessStepStatus(String currentProcessStepStatus) {
        this.currentProcessStepStatus = currentProcessStepStatus;
    }

    public void setStageFlags(Map<String, StageFlag> stageFlags) {
        this.stageFlags = stageFlags;
    }

    public String toString() {
        return "DomainProcessInfo(id=" + this.getId() + ", processActive=" + this.isProcessActive() + ", currentProcessId=" + this.getCurrentProcessId() + ", currentProcessStatus=" + this.getCurrentProcessStatus() + ", currentProcessStepName=" + this.getCurrentProcessStepName() + ", currentProcessStepStatus=" + this.getCurrentProcessStepStatus() + ")";
    }

    public static enum ProcessStatus {
        PENDING,
        RUNNING,
        COMPLETED,
        ERROR;

    }
}

