package org.tkit.rhpam.quarkus.common;

import lombok.Getter;


/**
 * Message Keys used in RHPAM lib
 */
@Getter
public enum MessageKeys {
    /**
     * Process step reports business error, but did not specify error code.
     */
    FAILED_STEP_WITHOUT_ERROR_CODE("TKIT_RHPAM_000001", "Process step result FAILED without FAILED_STEP_ERROR_CODE out param"),
    /**
     * Process step threw exception other then {@link org.tkit.rhpam.quarkus.messaging.common.RhpamException} and no error info provided
     */
    EXCEPTION_IN_STEP_WITHOUT_ERROR_CODE("TKIT_RHPAM_000002", "Process step result in unexpected exception without additional error info");


    private String errorCode;
    private String message;

    MessageKeys(String errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    @Override
    public String toString() {
        return  this.errorCode + " : " + this.message;
    }
}
