package org.tkit.rhpam.quarkus.messaging.emitters;

import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import io.smallrye.reactive.messaging.annotations.Merge;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.tkit.rhpam.quarkus.messaging.model.CommandType;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import java.io.IOException;

import static org.tkit.rhpam.quarkus.messaging.common.MessageUtil.*;

/**
 * The type Jbpm message emitter.
 */
@ApplicationScoped
@Traced
public class JbpmMessageEmitter {
    /**
     * The Emitter.
     */
    @Inject
    @Channel(RESPONSE_QUEUE)
    Emitter<String> emitter;

    /**
     * Notify jbpm.
     *
     * @param execution the execution
     * @param message   the message
     * @param result    the result
     * @throws IOException the io exception
     */
    public void notifyJBPM(ProcessStepExecution execution, AmqpMessage<String> message, ProcessStepExecutionResult result) throws IOException {
        // creates the response text message and send to response queue
        result.getParameters().put(PROP_TKIT_RESOLUTION_STATUS, result.getStatus().name());
        result.getParameters().put(PROP_TKIT_CORRELATION_ID, execution.getCorrelationId());


        OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder()
                .withApplicationProperties(message.getApplicationProperties())
                .withApplicationProperty(PROP_CMD, CommandType.COMPLETE_WORK_ITEM.name()).build();
        Message toEmit = Message.of(serializeBody(result.getParameters()));
        toEmit = toEmit.addMetadata(meta);
        emitter.send(toEmit);
    }

    /**
     * Emit a message to JBPM response queue
     * @param toEmit message to emit
     */
    public void emit(Message<String> toEmit) {
        this.emitter.send(toEmit);
    }
}
