package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;


/**
 * The type Activity event.
 */
public class ActivityEvent extends ProcessLogEvent {
    private @Valid
    Boolean businessRelevant = null;
    private @Valid
    Map<String, Object> variables = new HashMap<String, Object>();

    /**
     * Business relevant activity event.
     *
     * @param businessRelevant the business relevant
     * @return the activity event
     */
    public ActivityEvent businessRelevant(Boolean businessRelevant) {
        this.businessRelevant = businessRelevant;
        return this;
    }


    /**
     * Is business relevant boolean.
     *
     * @return the boolean
     */
    @JsonProperty("businessRelevant")

    public Boolean isBusinessRelevant() {
        return businessRelevant;
    }

    /**
     * Sets business relevant.
     *
     * @param businessRelevant the business relevant
     */
    public void setBusinessRelevant(Boolean businessRelevant) {
        this.businessRelevant = businessRelevant;
    }

    /**
     * Variables activity event.
     *
     * @param variables the variables
     * @return the activity event
     */
    public ActivityEvent variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }


    /**
     * Gets variables.
     *
     * @return the variables
     */
    @JsonProperty("variables")

    public Map<String, Object> getVariables() {
        return variables;
    }

    /**
     * Sets variables.
     *
     * @param variables the variables
     */
    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActivityEvent activityEvent = (ActivityEvent) o;
        return Objects.equals(businessRelevant, activityEvent.businessRelevant) &&
                Objects.equals(variables, activityEvent.variables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(businessRelevant, variables);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    businessRelevant: ").append(toIndentedString(businessRelevant)).append("\n");
        sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
