package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.Objects;


/**
 * The type Incident event.
 */
public class IncidentEvent extends ProcessLogEvent {
    private @Valid @NotNull
    String incidentId = null;

    /**
     * Incident id incident event.
     *
     * @param incidentId the incident id
     * @return the incident event
     */
    public IncidentEvent incidentId(String incidentId) {
        this.incidentId = incidentId;
        return this;
    }


    /**
     * Gets incident id.
     *
     * @return the incident id
     */
    @JsonProperty("incidentId")

    public String getIncidentId() {
        return incidentId;
    }

    /**
     * Sets incident id.
     *
     * @param incidentId the incident id
     */
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IncidentEvent incidentEvent = (IncidentEvent) o;
        return Objects.equals(incidentId, incidentEvent.incidentId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(incidentId);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    incidentId: ").append(toIndentedString(incidentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
