package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;


/**
 * The type Process log event.
 */
public class ProcessLogEvent {
    private @Valid
    String correlationId = null;
    private @Valid @NotNull
    Date eventTime = null;
    private @Valid @NotNull
    EventType processEventType = null;
    private @Valid @NotNull
    String processInstanceId = null;
    private @Valid @NotNull
    String processId = null;
    private @Valid
    Map<String, Object> metadata = new HashMap<String, Object>();
    private @Valid @NotNull
    String executionId = null;

    /**
     * Correlation id process log event.
     *
     * @param correlationId the correlation id
     * @return the process log event
     */
    public ProcessLogEvent correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }


    /**
     * Gets correlation id.
     *
     * @return the correlation id
     */
    @JsonProperty("correlationId")

    public String getCorrelationId() {
        return correlationId;
    }

    /**
     * Sets correlation id.
     *
     * @param correlationId the correlation id
     */
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    /**
     * Event time process log event.
     *
     * @param eventTime the event time
     * @return the process log event
     */
    public ProcessLogEvent eventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }


    /**
     * Gets event time.
     *
     * @return the event time
     */
    @JsonProperty("eventTime")

    public Date getEventTime() {
        return eventTime;
    }

    /**
     * Sets event time.
     *
     * @param eventTime the event time
     */
    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    /**
     * Process event type process log event.
     *
     * @param processEventType the process event type
     * @return the process log event
     */
    public ProcessLogEvent processEventType(EventType processEventType) {
        this.processEventType = processEventType;
        return this;
    }


    /**
     * Gets process event type.
     *
     * @return the process event type
     */
    @JsonProperty("processEventType")

    public EventType getProcessEventType() {
        return processEventType;
    }

    /**
     * Sets process event type.
     *
     * @param processEventType the process event type
     */
    public void setProcessEventType(EventType processEventType) {
        this.processEventType = processEventType;
    }

    /**
     * Process instance id process log event.
     *
     * @param processInstanceId the process instance id
     * @return the process log event
     */
    public ProcessLogEvent processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }


    /**
     * Gets process instance id.
     *
     * @return the process instance id
     */
    @JsonProperty("processInstanceId")

    public String getProcessInstanceId() {
        return processInstanceId;
    }

    /**
     * Sets process instance id.
     *
     * @param processInstanceId the process instance id
     */
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    /**
     * Process id process log event.
     *
     * @param processId the process id
     * @return the process log event
     */
    public ProcessLogEvent processId(String processId) {
        this.processId = processId;
        return this;
    }


    /**
     * Gets process id.
     *
     * @return the process id
     */
    @JsonProperty("processId")

    public String getProcessId() {
        return processId;
    }

    /**
     * Sets process id.
     *
     * @param processId the process id
     */
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    /**
     * Metadata process log event.
     *
     * @param metadata the metadata
     * @return the process log event
     */
    public ProcessLogEvent metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }


    /**
     * Gets metadata.
     *
     * @return the metadata
     */
    @JsonProperty("metadata")

    public Map<String, Object> getMetadata() {
        return metadata;
    }

    /**
     * Sets metadata.
     *
     * @param metadata the metadata
     */
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    /**
     * Execution id process log event.
     *
     * @param executionId the execution id
     * @return the process log event
     */
    public ProcessLogEvent executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }


    /**
     * Gets execution id.
     *
     * @return the execution id
     */
    @JsonProperty("executionId")

    public String getExecutionId() {
        return executionId;
    }

    /**
     * Sets execution id.
     *
     * @param executionId the execution id
     */
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProcessLogEvent processLogEvent = (ProcessLogEvent) o;
        return Objects.equals(correlationId, processLogEvent.correlationId) &&
                Objects.equals(eventTime, processLogEvent.eventTime) &&
                Objects.equals(processEventType, processLogEvent.processEventType) &&
                Objects.equals(processInstanceId, processLogEvent.processInstanceId) &&
                Objects.equals(processId, processLogEvent.processId) &&
                Objects.equals(metadata, processLogEvent.metadata) &&
                Objects.equals(executionId, processLogEvent.executionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(correlationId, eventTime, processEventType, processInstanceId, processId, metadata, executionId);
    }

    /**
     * To pretty string string.
     *
     * @return the string
     */
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessLogEvent {\n");

        sb.append("    correlationId: ").append(toIndentedString(correlationId)).append("\n");
        sb.append("    eventTime: ").append(toIndentedString(eventTime)).append("\n");
        sb.append("    processEventType: ").append(toIndentedString(processEventType)).append("\n");
        sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
        sb.append("    processId: ").append(toIndentedString(processId)).append("\n");
        sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
        sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" { processInstance: "  + this.getProcessInstanceId());
        sb.append(", executionId: "  + this.getExecutionId());
        sb.append(", processId: "  + this.getProcessId());
        sb.append(" }");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
