package org.tkit.rhpam.quarkus.messaging;

import lombok.extern.slf4j.Slf4j;
import org.eclipse.microprofile.opentracing.Traced;
import org.hibernate.service.spi.ServiceException;
import org.tkit.quarkus.log.cdi.LogService;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.emitters.FailedStepEmitter;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;
import org.tkit.rhpam.quarkus.messaging.model.ResolutionStatus;
import org.tkit.rhpam.quarkus.process.ProcessStepService;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
@Slf4j
@Traced
public class BusinessErrorHandlerStepService implements ProcessStepService {
    private static final String PARAM_REFERENCED_STEP_NAME = "referencedStepId";
    private static final String PARAM_RESOLUTION_SIGNAL_NAME = "resolutionSignalId";
    private static final String PARAM_RESOLUTION_ACTIONS = "resolutionActions";

    @Inject
    FailedStepService failedStepService;
    @Inject
    FailedStepEmitter failedStepEmitter;
    @Override
    @LogService(stacktrace = false)
    public ProcessStepExecutionResult doExecute(ProcessStepExecution workItem) throws RhpamException {

            String referencedStepName = workItem.getParameter(PARAM_REFERENCED_STEP_NAME);
            String resolutionSignalId = workItem.getParameter(PARAM_RESOLUTION_SIGNAL_NAME);
            String resolutionActions = workItem.getParameter(PARAM_RESOLUTION_ACTIONS);
            if (referencedStepName == null || resolutionSignalId == null || resolutionActions == null) {
                log.error("Invalid business error handler definition! Please specify all of {referencedStepName,resolutionSignalId," +
                        "resolutionActions}");
            }
            // at this point, we have no info about the real step that failed, but we should have a prepared FailedStep in DB, so we update it
            FailedStep failedStep = failedStepService.updateFailedStep(workItem, referencedStepName, resolutionActions, resolutionSignalId);

            failedStepService.emitFailedStepEvent(failedStep);
            //This does not throw exception
//            supportToolSubmitterService.submitExternalSupportToolIssue(failedStep);
            return ProcessStepExecutionResult.builder().status(ResolutionStatus.SUCCESSFUL).build();
    }
}
