package org.tkit.rhpam.quarkus.process;

import org.tkit.rhpam.quarkus.messaging.common.Constants;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;

/**
 * The interface Process step service.
 */
public interface ProcessStepService {

    /**
     * Execute the process work item.
     * <p>
     * When you want to indicate a negative outcome, handled by the Busiess Error Handler WIH, specify these 3 variables in output:
     * {@link Constants#FAILED_STEP_ERROR_CODE} - for error code,
     * {@link Constants#FAILED_STEP_ERROR_MSG} - for error message text,
     * {@link Constants#FAILED_STEP_DEEP_LINK} - for backlink to the failed object, e.g. link to Object
     * detail in
     * our UI view,
     *
     * @param workItem the process work item.
     * @return the result parameters for the workflow.
     * @throws RhpamException if the method fails.
     */
    ProcessStepExecutionResult doExecute(ProcessStepExecution workItem) throws RhpamException;

    /**
     * Provide any additional error information in case the processing of <code>#doExecute</code> has failed.
     *
     * @param workItem workitem that failed
     * @param e        exception that occurred
     * @return instance of {@link AdditionalErrorInfo}, most important attributes are <code>errorCode</code> and <code>deepLink</code> - for back
     * navigation from support tool.
     */
    default AdditionalErrorInfo provideErrorInformation(ProcessStepExecution workItem, Exception e) {
        return null;
    }


}
