package org.tkit.rhpam.quarkus.tracing;

import static java.lang.String.valueOf;

import io.opentracing.propagation.TextMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HeadersMapExtractAdapter implements TextMap {

  private final Map<String, String> map = new HashMap<>();

  public HeadersMapExtractAdapter(Map<String, Object> headers) {
    if (headers == null) {
      return;
    }
    for (Map.Entry<String, Object> entry : headers.entrySet()) {
      map.put(decodeDash(entry.getKey()), valueOf(entry.getValue()));
    }
  }

  @Override
  public Iterator<Map.Entry<String, String>> iterator() {
    return map.entrySet().iterator();
  }

  @Override
  public void put(String key, String value) {
    throw new UnsupportedOperationException(
        "HeadersMapExtractAdapter should only be used with Tracer.extract()");
  }

  private String decodeDash(String key) {
    return key.replace("_$dash$_", "-");
  }
}