/*
 * Decompiled with CFR 0.152.
 */
package ext.api.centrallog.api;

import ext.api.centrallog.api.CentralLogObjectMapper;
import ext.api.centrallog.model.MessageEvent;
import ext.api.centrallog.model.NodeEndEvent;
import ext.api.centrallog.model.NodeStartEvent;
import ext.api.centrallog.model.OpenIncidentEvent;
import ext.api.centrallog.model.ProcessEndEvent;
import ext.api.centrallog.model.ProcessLogEvent;
import ext.api.centrallog.model.ProcessStartEvent;
import ext.api.centrallog.model.ResolvedIncidentEvent;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;

@ApplicationScoped
@Transactional
@Traced
public class ProcessLogEventEmitter {
    private static final Logger log = LoggerFactory.getLogger(ProcessLogEventEmitter.class);
    public static final String EVENT_QUEUE = "process-log-events";
    @Inject
    @Channel(value="jms.queue.process-log-events")
    Emitter<String> emitter;

    public void emitProcessEvent(@Valid NodeStartEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    public void emitProcessEvent(@Valid NodeEndEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    public void emitProcessEvent(@Valid ProcessEndEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    public void emitProcessEvent(@Valid ProcessStartEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    public void emitProcessEvent(@Valid OpenIncidentEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    public void emitMessageEvent(@Valid MessageEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    private void emitEvent(@Valid ProcessLogEvent event) throws RhpamException {
        try {
            log.info("Emit central log event type: {}, instanceId: {}, {}", new Object[]{event.getProcessEventType(), event.getProcessInstanceId(), event.toPrettyString()});
            OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withCreationTime(new Date().getTime()).withApplicationProperty("EVENT_TYPE", (Object)event.getProcessEventType().name()).build();
            String eventPayload = CentralLogObjectMapper.writer.writeValueAsString((Object)event);
            this.emitter.send(Message.of((Object)eventPayload, (Metadata)Metadata.of((Object[])new Object[]{meta})));
        }
        catch (Exception e) {
            throw new RhpamException(ErrorCodes.FAILED_TO_EMIT_MSG_EVENT.name(), e);
        }
    }

    public void emitProcessEvent(ResolvedIncidentEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    static enum ErrorCodes {
        FAILED_TO_EMIT_MSG_EVENT;

    }
}

