/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.domain.daos;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.eclipse.microprofile.opentracing.Traced;
import org.tkit.rhpam.quarkus.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.domain.models.StageFlag;

@ApplicationScoped
@Traced
@Transactional
public class DomainProcessInfoDAO {
    @PersistenceContext
    private EntityManager em;

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo selectForUpdate(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        try {
            return (DomainProcessInfo)this.em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.id = :id", DomainProcessInfo.class).setParameter("id", (Object)id).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo selectForUpdate(String domainRefKey, String domainRefId, String processId) {
        String id = domainRefKey + "#" + domainRefId;
        try {
            return (DomainProcessInfo)this.em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.id = :id AND dpi.currentProcessId = :processId", DomainProcessInfo.class).setParameter("id", (Object)id).setParameter("processId", (Object)processId).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo update(DomainProcessInfo toUpdate) {
        toUpdate = (DomainProcessInfo)this.em.merge((Object)toUpdate);
        this.em.flush();
        return toUpdate;
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo addStageFlag(String domainRefKey, String domainRefId, String flagName, Date date, String info) {
        DomainProcessInfo dpi = this.selectForUpdate(domainRefKey, domainRefId);
        StageFlag stageFlag = new StageFlag();
        stageFlag.setDate(date);
        stageFlag.setInfo(info);
        dpi.getStageFlags().put(flagName, stageFlag);
        return this.update(dpi);
    }
}

