/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.opentracing.Traced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.log.cdi.LogService;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.messaging.FailedStepService;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.emitters.FailedStepEmitter;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;
import org.tkit.rhpam.quarkus.messaging.model.ResolutionStatus;
import org.tkit.rhpam.quarkus.process.ProcessStepService;

@ApplicationScoped
@Traced
public class BusinessErrorHandlerStepService
implements ProcessStepService {
    private static final Logger log = LoggerFactory.getLogger(BusinessErrorHandlerStepService.class);
    private static final String PARAM_REFERENCED_STEP_NAME = "referencedStepId";
    private static final String PARAM_RESOLUTION_SIGNAL_NAME = "resolutionSignalId";
    private static final String PARAM_RESOLUTION_ACTIONS = "resolutionActions";
    @Inject
    FailedStepService failedStepService;
    @Inject
    FailedStepEmitter failedStepEmitter;

    @Override
    @LogService(stacktrace=false)
    public ProcessStepExecutionResult doExecute(ProcessStepExecution workItem) throws RhpamException {
        String referencedStepName = (String)workItem.getParameter(PARAM_REFERENCED_STEP_NAME);
        String resolutionSignalId = (String)workItem.getParameter(PARAM_RESOLUTION_SIGNAL_NAME);
        String resolutionActions = (String)workItem.getParameter(PARAM_RESOLUTION_ACTIONS);
        if (referencedStepName == null || resolutionSignalId == null || resolutionActions == null) {
            log.error("Invalid business error handler definition! Please specify all of {referencedStepName,resolutionSignalId,resolutionActions}");
        }
        FailedStep failedStep = this.failedStepService.updateFailedStep(workItem, referencedStepName, resolutionActions, resolutionSignalId);
        this.failedStepService.emitFailedStepEvent(failedStep);
        return ProcessStepExecutionResult.builder().status(ResolutionStatus.SUCCESSFUL).build();
    }
}

