/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging.emitters;

import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;

@ApplicationScoped
@Traced
public class FailedStepEmitter {
    @Inject
    @Channel(value="tkitRhpamFailedStepsOutgoing")
    Emitter<String> emitter;

    public void sendToFailedStepQueue(AmqpMessage<String> message, Map<String, Object> messageBody, AdditionalErrorInfo additionalErrorInfo, String errorCode) throws IOException {
        OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withApplicationProperties(message.getApplicationProperties()).withApplicationProperty("TKIT_FAILED_STEP", (Object)true).withApplicationProperty("TKIT_FS_ERROR_CODE", (Object)errorCode).withApplicationProperty("ORIG_QUEUE", (Object)message.getAddress()).build();
        String payload = null;
        payload = messageBody != null ? MessageUtil.serializeBody(messageBody) : (String)message.getPayload();
        if (payload == null || payload.isBlank()) {
            payload = MessageUtil.serializeBody(new HashMap<String, Object>());
        }
        Message toEmit = Message.of((Object)payload).addMetadata((Object)meta);
        this.emitter.send(toEmit);
    }
}

