package ext.api.centrallog.api;

import ext.api.centrallog.model.*;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;

import javax.enterprise.context.ApplicationScoped;
import javax.transaction.Transactional;
import javax.validation.Valid;

/**
 * The type Process log event emitter.
 */
@ApplicationScoped
@Slf4j
@Transactional
public class ProcessLogEventEmitter {
    /**
     * The constant PROCESS_LOG_EVENT_TYPE_KEY.
     */
    public static final String PROCESS_LOG_EVENT_TYPE_KEY = "EVENT_TYPE";

    /**
     * The constant EVENT_QUEUE.
     */
    public static final String EVENT_QUEUE = "process-log-events";


    /**
     * Emit process event.
     *
     * @param event the event
     * @throws RhpamException the rhpam exception
     */
    @Outgoing("process-log-events")
    public void emitProcessEvent(@Valid NodeStartEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    /**
     * Emit process event.
     *
     * @param event the event
     * @throws RhpamException the rhpam exception
     */
    @Outgoing("process-log-events")
    public void emitProcessEvent(@Valid NodeEndEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    /**
     * Emit process event.
     *
     * @param event the event
     * @throws RhpamException the rhpam exception
     */
    @Outgoing("process-log-events")
    public void emitProcessEvent(@Valid ProcessEndEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    /**
     * Emit process event.
     *
     * @param event the event
     * @throws RhpamException the rhpam exception
     */
    @Outgoing("process-log-events")
    public void emitProcessEvent(@Valid ProcessStartEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    /**
     * Emit process event.
     *
     * @param event the event
     * @throws RhpamException the rhpam exception
     */
    @Outgoing("process-log-events")
    public void emitProcessEvent(@Valid OpenIncidentEvent event) throws RhpamException {
        this.emitEvent(event);
    }


    private Message<String> emitEvent(@Valid ProcessLogEvent event) throws RhpamException {
        try {
            log.info("Central log event: {}", event.toPrettyString());
            String eventPayload = CentralLogObjectMapper.writer.writeValueAsString(event);
            return Message.of(eventPayload);
        } catch (Exception e) {
            throw new RhpamException(ErrorCodes.FAILED_TO_EMIT_MSG_EVENT.name(), e);
        }

    }

    /**
     * Emit process event.
     *
     * @param event the event
     * @throws RhpamException the rhpam exception
     */
    @Outgoing("process-log-events")
    public void emitProcessEvent(ResolvedIncidentEvent event) throws RhpamException {
        this.emitEvent(event);
    }


    /**
     * The enum Error codes.
     */
    enum ErrorCodes {
        /**
         * Failed to emit msg event error codes.
         */
        FAILED_TO_EMIT_MSG_EVENT;
    }
}
