package ext.api.centrallog.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import ext.api.centrallog.model.MessageEvent;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;

import javax.enterprise.context.ApplicationScoped;

import javax.transaction.Transactional;
import javax.validation.Valid;

/**
 * The type Process message event emitter.
 */
@ApplicationScoped
@Transactional
public class ProcessMessageEventEmitter {

    /**
     * Emit process message event message.
     *
     * @param event the event
     * @return the message
     * @throws JsonProcessingException the json processing exception
     */
    @Outgoing("process-log-events")
    public Message<String> emitProcessMessageEvent(@Valid MessageEvent event) throws JsonProcessingException {

            String eventPayload = CentralLogObjectMapper.writer.writeValueAsString(event);
            return Message.of(eventPayload);
    }

    /**
     * The enum Error codes.
     */
    enum ErrorCodes {
        /**
         * Failed to emit msg event error codes.
         */
        FAILED_TO_EMIT_MSG_EVENT;
    }
}
