package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets EventType
 */
public enum EventType {
    /**
     * Node end event event type.
     */
    NODE_END_EVENT("NODE_END_EVENT"),
    /**
     * Node start event event type.
     */
    NODE_START_EVENT("NODE_START_EVENT"),
    /**
     * Process end event event type.
     */
    PROCESS_END_EVENT("PROCESS_END_EVENT"),
    /**
     * Process start event event type.
     */
    PROCESS_START_EVENT("PROCESS_START_EVENT"),
    /**
     * Message event event type.
     */
    MESSAGE_EVENT("MESSAGE_EVENT"),
    /**
     * Open incident event event type.
     */
    OPEN_INCIDENT_EVENT("OPEN_INCIDENT_EVENT"),
    /**
     * Resolved incident event event type.
     */
    RESOLVED_INCIDENT_EVENT("RESOLVED_INCIDENT_EVENT");

    private String value;

    EventType(String value) {
        this.value = value;
    }

    /**
     * From value event type.
     *
     * @param text the text
     * @return the event type
     */
    @JsonCreator
    public static EventType fromValue(String text) {
        for (EventType b : EventType.values()) {
            if (String.valueOf(b.value).equals(text)) {
                return b;
            }
        }
        return null;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }
}
