/*
 * Decompiled with CFR 0.152.
 */
package ext.api.centrallog.api;

import ext.api.centrallog.api.CentralLogObjectMapper;
import ext.api.centrallog.model.NodeEndEvent;
import ext.api.centrallog.model.NodeStartEvent;
import ext.api.centrallog.model.OpenIncidentEvent;
import ext.api.centrallog.model.ProcessEndEvent;
import ext.api.centrallog.model.ProcessLogEvent;
import ext.api.centrallog.model.ProcessStartEvent;
import ext.api.centrallog.model.ResolvedIncidentEvent;
import javax.enterprise.context.ApplicationScoped;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;

@ApplicationScoped
@Transactional
public class ProcessLogEventEmitter {
    private static final Logger log = LoggerFactory.getLogger(ProcessLogEventEmitter.class);
    public static final String PROCESS_LOG_EVENT_TYPE_KEY = "EVENT_TYPE";
    public static final String EVENT_QUEUE = "process-log-events";

    @Outgoing(value="process-log-events")
    public void emitProcessEvent(@Valid NodeStartEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    @Outgoing(value="process-log-events")
    public void emitProcessEvent(@Valid NodeEndEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    @Outgoing(value="process-log-events")
    public void emitProcessEvent(@Valid ProcessEndEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    @Outgoing(value="process-log-events")
    public void emitProcessEvent(@Valid ProcessStartEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    @Outgoing(value="process-log-events")
    public void emitProcessEvent(@Valid OpenIncidentEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    private Message<String> emitEvent(@Valid ProcessLogEvent event) throws RhpamException {
        try {
            log.info("Central log event: {}", (Object)event.toPrettyString());
            String eventPayload = CentralLogObjectMapper.writer.writeValueAsString((Object)event);
            return Message.of((Object)eventPayload);
        }
        catch (Exception e) {
            throw new RhpamException(ErrorCodes.FAILED_TO_EMIT_MSG_EVENT.name(), e);
        }
    }

    @Outgoing(value="process-log-events")
    public void emitProcessEvent(ResolvedIncidentEvent event) throws RhpamException {
        this.emitEvent(event);
    }

    static enum ErrorCodes {
        FAILED_TO_EMIT_MSG_EVENT;

    }
}

