/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import io.quarkus.arc.Arc;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.vertx.mutiny.core.eventbus.EventBus;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.messaging.BusinessProcess;
import org.tkit.rhpam.quarkus.messaging.ProcessClientServiceV2;
import org.tkit.rhpam.quarkus.messaging.ProcessStepService;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;

@ApplicationScoped
public class TkitRhpamWIHService {
    private static final Logger log = LoggerFactory.getLogger(TkitRhpamWIHService.class);
    @Inject
    ProcessClientServiceV2 processClientServiceV2;
    @Inject
    EventBus bus;

    @Transactional(value=Transactional.TxType.REQUIRED)
    @Acknowledgment(value=Acknowledgment.Strategy.MANUAL)
    @Incoming(value="jms.queue.TKIT_RHPAM_WIH")
    public CompletionStage<Void> onWIHMessage(AmqpMessage<String> message) {
        ProcessStepExecution execution = this.processClientServiceV2.startLog((Message)message);
        long startTime = System.currentTimeMillis();
        log.info("Process work item {} started.", (Object)execution);
        return CompletableFuture.runAsync(() -> {
            ProcessStepService stepService = (ProcessStepService)Arc.container().instance(ProcessStepService.class, new Annotation[]{new BusinessProcess.Literal(execution.getProcessId())}).get();
            if (stepService == null) {
                log.error("No ProcessStepService for {}", (Object)execution.getProcessId());
            }
            AdditionalErrorInfo additionalErrorInfo = null;
            try {
                ProcessStepExecutionResult result = stepService.doExecute(execution);
                this.handleStepSuccess(execution, result, (Message<String>)message);
            }
            catch (Exception e) {
                additionalErrorInfo = stepService.provideErrorInformation(execution, e);
                log.error("Business failed", (Throwable)e);
                message.nack((Throwable)e);
            }
        });
    }

    private void handleStepFailed(ProcessStepExecution execution, Throwable t, Message<String> message) {
        log.info("#### handleStepFailed {}", t);
        try {
            this.processClientServiceV2.endLog(execution, null, message, t, null);
        }
        catch (Exception e) {
            log.error("EError in endlog", (Throwable)e);
        }
        message.nack(t);
        log.info("#### FINISHED handleStepFailed {}", t);
    }

    private void handleStepSuccess(ProcessStepExecution execution, ProcessStepExecutionResult processStepExecutionResult, Message<String> message) {
        log.info("#### handleStepSuccess {}", (Object)processStepExecutionResult);
        try {
            this.processClientServiceV2.endLog(execution, processStepExecutionResult, message, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("### FINISH handleStepSuccess");
    }
}

