/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import com.fasterxml.jackson.core.JsonProcessingException;
import ext.api.centrallog.api.ProcessLogEventEmitter;
import ext.api.centrallog.api.ProcessMessageEventEmitter;
import ext.api.centrallog.model.EventType;
import ext.api.centrallog.model.MessageEvent;
import ext.api.centrallog.model.NodeEndEvent;
import ext.api.centrallog.model.NodeStartEvent;
import ext.api.centrallog.model.Resolution;
import ext.api.centrallog.model.Severity;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import io.smallrye.reactive.messaging.amqp.IncomingAmqpMetadata;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.tkit.rhpam.quarkus.emitters.FailedStepEmitter;
import org.tkit.rhpam.quarkus.emitters.JbpmMessageEmitter;
import org.tkit.rhpam.quarkus.messaging.FailedStepService;
import org.tkit.rhpam.quarkus.messaging.MessageFactory;
import org.tkit.rhpam.quarkus.messaging.common.ExceptionUtil;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;
import org.tkit.rhpam.quarkus.messaging.model.NodeType;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;
import org.tkit.rhpam.quarkus.messaging.model.ResolutionStatus;

@ApplicationScoped
@Transactional
public class ProcessClientServiceV2 {
    private static final Logger log = LoggerFactory.getLogger(ProcessClientServiceV2.class);
    public static final String TKIT_RHPAM_SKIP_MESSAGE = "TKIT_RHPAM_SKIP_MESSAGE";
    private static final boolean AUTO_RETRY_ENABLED_DEFAULT = false;
    private static final int AUTO_RETRY_MAX_COUNT_DEFAULT = 3;
    private static final String AUTO_RETRY_ENABLED_PARAM_KEY = "autoRetryEnabled";
    private static final String AUTO_RETRY_MAX_COUNT_PARAM_KEY = "autoRetryMaxCount";
    @Inject
    ProcessMessageEventEmitter msgEmitter;
    @Inject
    ProcessLogEventEmitter processLogEventEmitter;
    @Inject
    FailedStepService failedStepService;
    @Inject
    FailedStepEmitter failedStepEmitter;
    @Inject
    JbpmMessageEmitter jbpmMessageEmitter;

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void endLog(ProcessStepExecution execution, ProcessStepExecutionResult result, Message message, Throwable exception, AdditionalErrorInfo additionalErrorInfo) throws Exception {
        if (exception == null) {
            this.endSuccessLog(execution, result, message);
        } else {
            this.endFailedLog(execution, message, exception, additionalErrorInfo);
        }
    }

    private void endSuccessLog(ProcessStepExecution execution, ProcessStepExecutionResult result, Message message) throws Exception {
        this.emitNodeEndEvent(execution, result);
        if (result.getStatus() == ResolutionStatus.FAILED) {
            this.failedStepService.createOrUpdateBusinessFailedStep(execution, result);
        }
        this.jbpmMessageEmitter.notifyJBPM(execution, message, result);
    }

    private void emitNodeEndEvent(ProcessStepExecution execution, ProcessStepExecutionResult result) throws RhpamException {
        NodeEndEvent endEvent = this.createNodeEndEvent(execution);
        endEvent.setResolution(Resolution.fromValue(result.getStatus().name()));
        endEvent.setVariables(result.getParameters());
        this.processLogEventEmitter.emitProcessEvent(endEvent);
    }

    private void emitNodeStartEvent(ProcessStepExecution execution) throws RhpamException {
        NodeStartEvent startEvent = new NodeStartEvent();
        startEvent.setNodeId(execution.getNodeId());
        startEvent.setNodeName(execution.getName());
        startEvent.setProcessId(execution.getProcessId());
        startEvent.setProcessInstanceId(String.valueOf(execution.getProcessInstanceId()));
        startEvent.setNodeType(ext.api.centrallog.model.NodeType.ACTIVITY);
        startEvent.setCorrelationId(execution.getCorrelationId());
        startEvent.setBusinessRelevant(true);
        startEvent.setEventTime(execution.getExecutionDate());
        startEvent.setProcessEventType(EventType.NODE_START_EVENT);
        startEvent.setExecutionId(execution.getExecutionId());
        startEvent.getMetadata().put("parentProcessInstanceId", execution.getParentProcessInstanceId());
        startEvent.getMetadata().put("referenceId", execution.getReferenceId());
        startEvent.getMetadata().put("referenceKey", execution.getReferenceKey());
        startEvent.setVariables(execution.getParameters());
        this.processLogEventEmitter.emitProcessEvent(startEvent);
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void technicalError(ProcessStepExecution workItem, ProcessStepExecutionResult result, Message message, Exception exception, AdditionalErrorInfo additionalErrorInfo) {
        try {
            String stacktrace = ExceptionUtil.getExceptionStackTrace(exception);
            String errorCode = null;
            if (additionalErrorInfo != null) {
                errorCode = additionalErrorInfo.getErrorCode();
            }
            if (errorCode == null) {
                errorCode = "TKIT_RHPAM_1000";
            }
            HashMap<String, Object> messageBody = new HashMap<String, Object>();
            messageBody.put("body", workItem.getParameters());
            messageBody.put("result", result);
            messageBody.put("stacktrace", stacktrace);
            this.failedStepEmitter.sendToFailedStepQueue(message, messageBody, additionalErrorInfo, errorCode);
        }
        catch (Exception cex) {
            log.error("Error complete the message.", (Throwable)cex);
        }
    }

    private void endFailedLog(ProcessStepExecution execution, Message message, Throwable ex, AdditionalErrorInfo additionalErrorInfo) throws RhpamException, IOException {
        String errorCode = this.getErrorCode(ex, additionalErrorInfo);
        this.emitNodeEndEvent(execution, ex, additionalErrorInfo);
        this.emitMessageEvent(execution, errorCode, ex, additionalErrorInfo);
        if (this.isAutoRetryAllowed(execution, message)) {
            throw new RhpamException("Error executing the work item! Retrying...");
        }
        this.failedStepEmitter.sendToFailedStepQueue(message, null, additionalErrorInfo, errorCode);
    }

    private void emitMessageEvent(ProcessStepExecution execution, String errorCode, Throwable ex, AdditionalErrorInfo additionalErrorInfo) throws JsonProcessingException {
        boolean skipMessage = this.getShouldSkipMessage(ex);
        String stacktrace = ExceptionUtil.getExceptionStackTrace(ex);
        if (!skipMessage) {
            MessageEvent msg = MessageFactory.createMessage(execution, errorCode, Severity.ERROR);
            msg.setContent(stacktrace);
            this.msgEmitter.emitProcessMessageEvent(msg);
        }
    }

    private void emitNodeEndEvent(ProcessStepExecution execution, Throwable ex, AdditionalErrorInfo additionalErrorInfo) throws RhpamException {
        NodeEndEvent endEvent = this.createNodeEndEvent(execution);
        endEvent.setResolution(Resolution.FAILED);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("exception", ex.getClass().getName());
        endEvent.setVariables(variables);
        this.processLogEventEmitter.emitProcessEvent(endEvent);
    }

    private NodeEndEvent createNodeEndEvent(ProcessStepExecution execution) {
        NodeEndEvent endEvent = new NodeEndEvent();
        endEvent.setNodeId(execution.getNodeId());
        endEvent.setProcessId(execution.getProcessId());
        endEvent.setProcessInstanceId(String.valueOf(execution.getProcessInstanceId()));
        endEvent.setBusinessRelevant(true);
        endEvent.setCorrelationId(execution.getCorrelationId());
        endEvent.setEventTime(new Date());
        endEvent.setExecutionId(execution.getExecutionId());
        endEvent.getMetadata().put("parentProcessInstanceId", execution.getParentProcessInstanceId());
        endEvent.getMetadata().put("TKIT_DO_NOT_CLOSE_STEP", true);
        endEvent.setProcessEventType(EventType.NODE_END_EVENT);
        return endEvent;
    }

    private boolean getShouldSkipMessage(Throwable ex) {
        return false;
    }

    private String getErrorCode(Throwable ex, AdditionalErrorInfo additionalErrorInfo) {
        if (additionalErrorInfo != null) {
            return additionalErrorInfo.getErrorCode();
        }
        return "TKIT_RHPAM_1000";
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public ProcessStepExecution startLog(Message message) {
        try {
            Tracer tracer;
            ProcessStepExecution execution = this.msgToStepExecution(message);
            if (execution.getParameter("data").toString().contains("fail")) {
                throw new IllegalArgumentException("I faile in start log");
            }
            MDC.put((String)"TKIT_PROCESS_ID", (String)execution.getProcessId());
            MDC.put((String)"TKIT_PROCESS_INSTANCE_ID", (String)String.valueOf(execution.getProcessInstanceId()));
            MDC.put((String)"TKIT_PROCESS_STEP", (String)String.valueOf(execution.getName()));
            MDC.put((String)"TKIT_PROCESS_REF", (String)execution.getReferenceId());
            MDC.put((String)"TKIT_PROCESS_REF_TYPE", (String)execution.getReferenceKey());
            if (GlobalTracer.isRegistered() && (tracer = GlobalTracer.get()) != null && tracer.activeSpan() != null) {
                tracer.activeSpan().setOperationName(execution.getName());
                tracer.activeSpan().setTag("process", execution.getProcessName());
                tracer.activeSpan().setTag("processInstance", (Number)execution.getProcessInstanceId());
                tracer.activeSpan().setTag("processRef", execution.getReferenceId());
                tracer.activeSpan().setTag("processRefType", execution.getReferenceKey());
            }
            this.emitNodeStartEvent(execution);
            return execution;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error create start log", ex);
        }
    }

    private ProcessStepExecution msgToStepExecution(Message msg) throws IOException {
        ProcessStepExecution execution = ProcessStepExecution.builder().build();
        execution.setProcessInstanceId((Long)MessageUtil.getProperty(msg, "TKIT_PROCESS_INSTANCE_ID"));
        execution.setWorkItemId((Long)MessageUtil.getProperty(msg, "TKIT_WORK_ITEM_ID"));
        execution.setDeploymentId((String)MessageUtil.getProperty(msg, "TKIT_DEPLOYMENT_ID"));
        execution.setProcessVersion((String)MessageUtil.getProperty(msg, "TKIT_PROCESS_VERSION"));
        execution.setProcessId((String)MessageUtil.getProperty(msg, "TKIT_PROCESS_ID"));
        execution.setParentProcessInstanceId((Long)MessageUtil.getProperty(msg, "TKIT_PARENT_PROCESS_INSTANCE_ID"));
        Long refBid = (Long)MessageUtil.getProperty(msg, "TKIT_REFERENCE_BID");
        execution.setReferenceId("" + refBid);
        execution.setReferenceKey((String)MessageUtil.getProperty(msg, "TKIT_REFERENCE_KEY"));
        execution.setProcessName((String)MessageUtil.getProperty(msg, "TKIT_PROCESS_NAME"));
        Long nodeId = (Long)MessageUtil.getProperty(msg, "TKIT_NODE_ID");
        execution.setNodeId(nodeId != null ? String.valueOf(nodeId) : null);
        execution.setNodeType(NodeType.WORK_ITEM);
        execution.setCorrelationId(UUID.randomUUID().toString());
        Long workItemId = (Long)MessageUtil.getProperty(msg, "TKIT_WORK_ITEM_ID");
        execution.setExecutionId("" + workItemId);
        execution.setName((String)MessageUtil.getProperty(msg, "TKIT_NODE_NAME"));
        execution.setExecutionDate(MessageUtil.getStringDateProperty((Message<String>)msg, "TKIT_EXECUTION_DATE", new Date()));
        execution.setParameters(MessageUtil.deserializeBody((Message<String>)msg));
        return execution;
    }

    private boolean isAutoRetryAllowed(ProcessStepExecution execution, Message message) {
        boolean retryEnabled = false;
        int deliveryCount = -1;
        Object autoRetryEnabled = null;
        Object autoRetryMaxCount = null;
        try {
            IncomingAmqpMetadata meta = (IncomingAmqpMetadata)message.getMetadata(IncomingAmqpMetadata.class).get();
            deliveryCount = meta.getDeliveryCount();
            Map<String, Object> paramMap = execution.getParameters();
            if (paramMap != null) {
                autoRetryEnabled = paramMap.get(AUTO_RETRY_ENABLED_PARAM_KEY);
                autoRetryMaxCount = paramMap.get(AUTO_RETRY_MAX_COUNT_PARAM_KEY);
            }
        }
        catch (Exception e) {
            log.error("Error reading body from message", (Throwable)e);
        }
        if (autoRetryEnabled == null) {
            autoRetryEnabled = System.getenv("ORG_TKIT_RHPAM_AUTO_RETRY_ON_FATAL_ERROR_ENABLED");
        }
        if (autoRetryEnabled != null) {
            if (autoRetryEnabled instanceof String) {
                retryEnabled = Boolean.parseBoolean((String)autoRetryEnabled);
            } else if (autoRetryEnabled instanceof Boolean) {
                retryEnabled = (Boolean)autoRetryEnabled;
            } else {
                log.warn("Auto retry enabled flag cannot be parsed from {} to boolean", autoRetryEnabled);
                return false;
            }
        }
        int retryMaxCount = this.getAutoRetryMaxCount(autoRetryMaxCount);
        boolean result = retryEnabled && retryMaxCount > deliveryCount;
        log.info("Auto retry {} max count {} delivery count {}. Result: {}", new Object[]{retryEnabled, retryMaxCount, deliveryCount, result});
        return result;
    }

    private int getAutoRetryMaxCount(Object autoRetryMaxCount) {
        int retryMaxCount = 3;
        if (autoRetryMaxCount == null) {
            autoRetryMaxCount = System.getenv("ORG_TKIT_RHPAM_AUTO_RETRY_MAX_ATTEMPTS");
        }
        if (autoRetryMaxCount != null) {
            if (autoRetryMaxCount instanceof String) {
                try {
                    retryMaxCount = Integer.parseInt((String)autoRetryMaxCount);
                }
                catch (Exception e) {
                    log.warn("Could not parse max retry count string {} to number", autoRetryMaxCount);
                }
            } else if (autoRetryMaxCount instanceof Integer) {
                retryMaxCount = (Integer)autoRetryMaxCount;
            } else {
                log.warn("Max retry count is of undefined type with value {}. Using default.", autoRetryMaxCount);
            }
        }
        return retryMaxCount;
    }
}

