/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.process;

import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.model.CommandType;

@ApplicationScoped
@Transactional(value=Transactional.TxType.REQUIRED)
public class ProcessService {
    private static final Logger log = LoggerFactory.getLogger(ProcessService.class);
    @Inject
    @Channel(value="jms.queue.ResponseExecutionQueue")
    Emitter<String> emitter;

    public String startProcess(String deploymentId, String processId, Long referenceBid, String referenceKey, Map<String, Object> data) throws RhpamException {
        try {
            String parameters = MessageUtil.serializeBody(data);
            String guid = UUID.randomUUID().toString();
            Message toEmit = Message.of((Object)parameters);
            OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withApplicationProperty("TKIT_DEPLOYMENT_ID", (Object)deploymentId).withApplicationProperty("TKIT_PROCESS_LOG_GUID", (Object)guid).withApplicationProperty("TKIT_REFERENCE_BID", (Object)referenceBid).withApplicationProperty("TKIT_REFERENCE_KEY", (Object)referenceKey).withApplicationProperty("TKIT_PROCESS_ID", (Object)processId).withApplicationProperty("TKIT_CMD", (Object)CommandType.START_PROCESS.name()).build();
            toEmit.addMetadata((Object)meta);
            this.emitter.send(toEmit);
            return guid;
        }
        catch (Exception ex) {
            throw new RhpamException(ErrorKeys.ERROR_START_PROCESS.name(), ex);
        }
    }

    public void sendMessage(String deploymentId, Long processInstanceId, String messageId, Object data) throws RhpamException {
        this.sendSignal(deploymentId, processInstanceId, "Message-" + messageId, data);
    }

    public void sendSignal(String deploymentId, Long processInstanceId, String signalId, Object data) throws RhpamException {
        try {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            if (data != null) {
                tmp.put("TKIT_SIGNAL_DATA", data);
            }
            String parameters = MessageUtil.serializeBody(tmp);
            Message toEmit = Message.of((Object)parameters);
            OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withApplicationProperty("TKIT_DEPLOYMENT_ID", (Object)deploymentId).withApplicationProperty("TKIT_PROCESS_INSTANCE_ID", (Object)processInstanceId).withApplicationProperty("TKIT_SIGNAL", (Object)signalId).withApplicationProperty("TKIT_CMD", (Object)CommandType.SEND_SIGNAL.name()).build();
            toEmit.addMetadata((Object)meta);
            this.emitter.send(toEmit);
        }
        catch (Exception ex) {
            throw new RhpamException(ErrorKeys.ERROR_SEND_SIGNAL.name(), ex);
        }
    }

    static enum ErrorKeys {
        ERROR_START_PROCESS,
        ERROR_SEND_SIGNAL;

    }
}

