package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets PriorityLevel
 */
public enum PriorityLevel {
    /**
     * Low priority level.
     */
    LOW("LOW"),
    /**
     * Medium priority level.
     */
    MEDIUM("MEDIUM"),
    /**
     * High priority level.
     */
    HIGH("HIGH");

    private String value;

    PriorityLevel(String value) {
        this.value = value;
    }

    /**
     * From value priority level.
     *
     * @param text the text
     * @return the priority level
     */
    @JsonCreator
    public static PriorityLevel fromValue(String text) {
        for (PriorityLevel b : PriorityLevel.values()) {
            if (String.valueOf(b.value).equals(text)) {
                return b;
            }
        }
        return null;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }
}
