package org.tkit.rhpam.quarkus.emitters;

import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.tkit.rhpam.quarkus.messaging.common.Constants;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import java.io.IOException;
import java.util.Map;

/**
 * The type Failed step emitter.
 */
@ApplicationScoped
@Transactional
public class FailedStepEmitter {
    /**
     * The Emitter.
     */
    @Inject
    @Channel(Constants.FAILED_STEPS_QUEUE)
    Emitter<String> emitter;

    /**
     * Send to failed step queue.
     *
     * @param message             the message
     * @param messageBody         the message body
     * @param additionalErrorInfo the additional error info
     * @param errorCode           the error code
     * @throws IOException the io exception
     */
    public void sendToFailedStepQueue(Message message, Map<String, Object> messageBody, AdditionalErrorInfo additionalErrorInfo, String errorCode) throws  IOException {
       Message<String> toEmit;
        if (messageBody != null) {
            toEmit = message.withPayload(MessageUtil.serializeBody(messageBody));
        } else {
            toEmit = message;
        }
        emitter.send(toEmit);
    }


}
