package org.tkit.rhpam.quarkus.emitters;

import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.tkit.rhpam.quarkus.messaging.model.CommandType;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import java.io.IOException;

import static org.tkit.rhpam.quarkus.messaging.common.MessageUtil.*;

/**
 * The type Jbpm message emitter.
 */
@ApplicationScoped
@Transactional
public class JbpmMessageEmitter {
    /**
     * The Emitter.
     */
    @Inject
    @Channel(RESPONSE_QUEUE)
    Emitter<String> emitter;

    /**
     * Notify jbpm.
     *
     * @param execution the execution
     * @param message   the message
     * @param result    the result
     * @throws IOException the io exception
     */
    public void notifyJBPM(ProcessStepExecution execution, Message message, ProcessStepExecutionResult result) throws IOException {
        // creates the response text message and send to response queue
        result.getParameters().put(PROP_TKIT_RESOLUTION_STATUS, result.getStatus().name());
        result.getParameters().put(PROP_TKIT_CORRELATION_ID, execution.getCorrelationId());
        Message toEmit = message.withPayload(serializeBody(result.getParameters()));
        OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withApplicationProperty(PROP_CMD, CommandType.COMPLETE_WORK_ITEM.name()).build();
        toEmit.addMetadata(meta);
        emitter.send(toEmit);
    }
}
