package org.tkit.rhpam.quarkus.processlog.domain.daos;

import org.tkit.rhpam.quarkus.processlog.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.processlog.domain.models.StageFlag;

import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import java.util.Date;


@ApplicationScoped
public class DomainProcessInfoDAO {
    @PersistenceContext
    private EntityManager em;

    public DomainProcessInfo findByDomainRefs(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        return em.find(DomainProcessInfo.class, id);
    }

    @Transactional(Transactional.TxType.REQUIRED)
    public DomainProcessInfo selectForUpdate(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        return em.find(DomainProcessInfo.class, id, LockModeType.PESSIMISTIC_WRITE);
    }

    @Transactional(Transactional.TxType.REQUIRED)
    public DomainProcessInfo update(DomainProcessInfo toUpdate) {
        toUpdate = em.merge(toUpdate);
        em.flush();
        return toUpdate;
    }

    @Transactional(Transactional.TxType.REQUIRED)
    public DomainProcessInfo addStageFlag(String domainRefKey, String domainRefId, String flagName, Date date, String info) {
        DomainProcessInfo dpi = this.selectForUpdate(domainRefKey, domainRefId);
        StageFlag stageFlag = new StageFlag();
        stageFlag.setDate(date);
        stageFlag.setInfo(info);
        dpi.getStageFlags().put(flagName, stageFlag);
        return this.update(dpi);
    }
}
