package org.tkit.rhpam.quarkus.processlog.domain.models;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.util.Date;
import java.util.Map;

@Entity
@Getter
@Setter
@Table(name = "pl_domain_process_info")
@ToString(of = {"id", "currentProcessId", "currentProcessStepStatus", "currentProcessStepName", "currentProcessStepStatus"})
public class DomainProcessInfo {
    @Id
    private String id;
    private boolean processActive;
    private String currentProcessId;
    private Long currentProcessInstanceId;
    @Temporal(TemporalType.TIMESTAMP)
    private Date currentProcessStartTime;
    @Enumerated(EnumType.STRING)
    private ProcessStatus currentProcessStatus;
    private String currentProcessInitiator;
    private String currentProcessStepName;
    private String currentProcessStepStatus;
    @ElementCollection(fetch = FetchType.LAZY)
    @MapKeyColumn(name = "stage")
    @CollectionTable(
            name = "pl_process_stages",
            joinColumns = @JoinColumn(name = "process_info_id")
    )
    private Map<String, StageFlag> stageFlags;

    public DomainProcessInfo() {

    }

    public DomainProcessInfo(String domainRefKey, String domainRefId) {
        this.id = domainRefKey + "#" + domainRefId;
    }

    public enum ProcessStatus {
        PENDING, RUNNING, COMPLETED, ERROR;
    }

}
