/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.processlog.domain.daos;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.tkit.rhpam.quarkus.processlog.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.processlog.domain.models.StageFlag;

@ApplicationScoped
public class DomainProcessInfoDAO {
    @PersistenceContext
    private EntityManager em;

    public DomainProcessInfo findByDomainRefs(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        return (DomainProcessInfo)this.em.find(DomainProcessInfo.class, (Object)id);
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo selectForUpdate(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        return (DomainProcessInfo)this.em.find(DomainProcessInfo.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo update(DomainProcessInfo toUpdate) {
        toUpdate = (DomainProcessInfo)this.em.merge((Object)toUpdate);
        this.em.flush();
        return toUpdate;
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo addStageFlag(String domainRefKey, String domainRefId, String flagName, Date date, String info) {
        DomainProcessInfo dpi = this.selectForUpdate(domainRefKey, domainRefId);
        StageFlag stageFlag = new StageFlag();
        stageFlag.setDate(date);
        stageFlag.setInfo(info);
        dpi.getStageFlags().put(flagName, stageFlag);
        return this.update(dpi);
    }
}

