package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;


import javax.validation.Valid;
import java.util.Objects;


/**
 * The type Process start event.
 */
public class ProcessStartEvent extends ActivityEvent {
    private @Valid
    String businessKey = null;
    private @Valid
    String businessKeyType = null;
    private @Valid
    String deploymentId = null;
    private @Valid
    String parentProcessNodeId = null;
    private @Valid
    String parentProcessExecutionId = null;
    private @Valid
    String parentProcessInstanceId = null;
    private @Valid
    String parentProcessId = null;
    private @Valid
    String processExecutor = null;
    private @Valid
    String processName = null;
    private @Valid
    String processVersion = null;
    private @Valid
    String rootProcessInstanceId = null;
    private @Valid
    String rootProcessId = null;

    /**
     * Business key process start event.
     *
     * @param businessKey the business key
     * @return the process start event
     */
    public ProcessStartEvent businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }


    /**
     * Gets business key.
     *
     * @return the business key
     */
    @JsonProperty("businessKey")

    public String getBusinessKey() {
        return businessKey;
    }

    /**
     * Sets business key.
     *
     * @param businessKey the business key
     */
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    /**
     * Business key type process start event.
     *
     * @param businessKeyType the business key type
     * @return the process start event
     */
    public ProcessStartEvent businessKeyType(String businessKeyType) {
        this.businessKeyType = businessKeyType;
        return this;
    }


    /**
     * Gets business key type.
     *
     * @return the business key type
     */
    @JsonProperty("businessKeyType")

    public String getBusinessKeyType() {
        return businessKeyType;
    }

    /**
     * Sets business key type.
     *
     * @param businessKeyType the business key type
     */
    public void setBusinessKeyType(String businessKeyType) {
        this.businessKeyType = businessKeyType;
    }

    /**
     * Deployment id process start event.
     *
     * @param deploymentId the deployment id
     * @return the process start event
     */
    public ProcessStartEvent deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }


    /**
     * Gets deployment id.
     *
     * @return the deployment id
     */
    @JsonProperty("deploymentId")

    public String getDeploymentId() {
        return deploymentId;
    }

    /**
     * Sets deployment id.
     *
     * @param deploymentId the deployment id
     */
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    /**
     * Parent process node id process start event.
     *
     * @param parentProcessNodeId the parent process node id
     * @return the process start event
     */
    public ProcessStartEvent parentProcessNodeId(String parentProcessNodeId) {
        this.parentProcessNodeId = parentProcessNodeId;
        return this;
    }


    /**
     * Gets parent process node id.
     *
     * @return the parent process node id
     */
    @JsonProperty("parentProcessNodeId")

    public String getParentProcessNodeId() {
        return parentProcessNodeId;
    }

    /**
     * Sets parent process node id.
     *
     * @param parentProcessNodeId the parent process node id
     */
    public void setParentProcessNodeId(String parentProcessNodeId) {
        this.parentProcessNodeId = parentProcessNodeId;
    }

    /**
     * Parent process execution id process start event.
     *
     * @param parentProcessExecutionId the parent process execution id
     * @return the process start event
     */
    public ProcessStartEvent parentProcessExecutionId(String parentProcessExecutionId) {
        this.parentProcessExecutionId = parentProcessExecutionId;
        return this;
    }


    /**
     * Gets parent process execution id.
     *
     * @return the parent process execution id
     */
    @JsonProperty("parentProcessExecutionId")

    public String getParentProcessExecutionId() {
        return parentProcessExecutionId;
    }

    /**
     * Sets parent process execution id.
     *
     * @param parentProcessExecutionId the parent process execution id
     */
    public void setParentProcessExecutionId(String parentProcessExecutionId) {
        this.parentProcessExecutionId = parentProcessExecutionId;
    }

    /**
     * Parent process instance id process start event.
     *
     * @param parentProcessInstanceId the parent process instance id
     * @return the process start event
     */
    public ProcessStartEvent parentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
        return this;
    }


    /**
     * Gets parent process instance id.
     *
     * @return the parent process instance id
     */
    @JsonProperty("parentProcessInstanceId")

    public String getParentProcessInstanceId() {
        return parentProcessInstanceId;
    }

    /**
     * Sets parent process instance id.
     *
     * @param parentProcessInstanceId the parent process instance id
     */
    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    /**
     * Parent process id process start event.
     *
     * @param parentProcessId the parent process id
     * @return the process start event
     */
    public ProcessStartEvent parentProcessId(String parentProcessId) {
        this.parentProcessId = parentProcessId;
        return this;
    }


    /**
     * Gets parent process id.
     *
     * @return the parent process id
     */
    @JsonProperty("parentProcessId")

    public String getParentProcessId() {
        return parentProcessId;
    }

    /**
     * Sets parent process id.
     *
     * @param parentProcessId the parent process id
     */
    public void setParentProcessId(String parentProcessId) {
        this.parentProcessId = parentProcessId;
    }

    /**
     * Process executor process start event.
     *
     * @param processExecutor the process executor
     * @return the process start event
     */
    public ProcessStartEvent processExecutor(String processExecutor) {
        this.processExecutor = processExecutor;
        return this;
    }


    /**
     * Gets process executor.
     *
     * @return the process executor
     */
    @JsonProperty("processExecutor")

    public String getProcessExecutor() {
        return processExecutor;
    }

    /**
     * Sets process executor.
     *
     * @param processExecutor the process executor
     */
    public void setProcessExecutor(String processExecutor) {
        this.processExecutor = processExecutor;
    }

    /**
     * Process name process start event.
     *
     * @param processName the process name
     * @return the process start event
     */
    public ProcessStartEvent processName(String processName) {
        this.processName = processName;
        return this;
    }


    /**
     * Gets process name.
     *
     * @return the process name
     */
    @JsonProperty("processName")

    public String getProcessName() {
        return processName;
    }

    /**
     * Sets process name.
     *
     * @param processName the process name
     */
    public void setProcessName(String processName) {
        this.processName = processName;
    }

    /**
     * Process version process start event.
     *
     * @param processVersion the process version
     * @return the process start event
     */
    public ProcessStartEvent processVersion(String processVersion) {
        this.processVersion = processVersion;
        return this;
    }


    /**
     * Gets process version.
     *
     * @return the process version
     */
    @JsonProperty("processVersion")

    public String getProcessVersion() {
        return processVersion;
    }

    /**
     * Sets process version.
     *
     * @param processVersion the process version
     */
    public void setProcessVersion(String processVersion) {
        this.processVersion = processVersion;
    }

    /**
     * Root process instance id process start event.
     *
     * @param rootProcessInstanceId the root process instance id
     * @return the process start event
     */
    public ProcessStartEvent rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }


    /**
     * Gets root process instance id.
     *
     * @return the root process instance id
     */
    @JsonProperty("rootProcessInstanceId")

    public String getRootProcessInstanceId() {
        return rootProcessInstanceId;
    }

    /**
     * Sets root process instance id.
     *
     * @param rootProcessInstanceId the root process instance id
     */
    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    /**
     * Root process id process start event.
     *
     * @param rootProcessId the root process id
     * @return the process start event
     */
    public ProcessStartEvent rootProcessId(String rootProcessId) {
        this.rootProcessId = rootProcessId;
        return this;
    }


    /**
     * Gets root process id.
     *
     * @return the root process id
     */
    @JsonProperty("rootProcessId")

    public String getRootProcessId() {
        return rootProcessId;
    }

    /**
     * Sets root process id.
     *
     * @param rootProcessId the root process id
     */
    public void setRootProcessId(String rootProcessId) {
        this.rootProcessId = rootProcessId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProcessStartEvent processStartEvent = (ProcessStartEvent) o;
        return Objects.equals(businessKey, processStartEvent.businessKey) &&
                Objects.equals(businessKeyType, processStartEvent.businessKeyType) &&
                Objects.equals(deploymentId, processStartEvent.deploymentId) &&
                Objects.equals(parentProcessNodeId, processStartEvent.parentProcessNodeId) &&
                Objects.equals(parentProcessExecutionId, processStartEvent.parentProcessExecutionId) &&
                Objects.equals(parentProcessInstanceId, processStartEvent.parentProcessInstanceId) &&
                Objects.equals(parentProcessId, processStartEvent.parentProcessId) &&
                Objects.equals(processExecutor, processStartEvent.processExecutor) &&
                Objects.equals(processName, processStartEvent.processName) &&
                Objects.equals(processVersion, processStartEvent.processVersion) &&
                Objects.equals(rootProcessInstanceId, processStartEvent.rootProcessInstanceId) &&
                Objects.equals(rootProcessId, processStartEvent.rootProcessId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(businessKey, businessKeyType, deploymentId, parentProcessNodeId, parentProcessExecutionId, parentProcessInstanceId, parentProcessId, processExecutor, processName, processVersion, rootProcessInstanceId, rootProcessId);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessStartEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
        sb.append("    businessKeyType: ").append(toIndentedString(businessKeyType)).append("\n");
        sb.append("    deploymentId: ").append(toIndentedString(deploymentId)).append("\n");
        sb.append("    parentProcessNodeId: ").append(toIndentedString(parentProcessNodeId)).append("\n");
        sb.append("    parentProcessExecutionId: ").append(toIndentedString(parentProcessExecutionId)).append("\n");
        sb.append("    parentProcessInstanceId: ").append(toIndentedString(parentProcessInstanceId)).append("\n");
        sb.append("    parentProcessId: ").append(toIndentedString(parentProcessId)).append("\n");
        sb.append("    processExecutor: ").append(toIndentedString(processExecutor)).append("\n");
        sb.append("    processName: ").append(toIndentedString(processName)).append("\n");
        sb.append("    processVersion: ").append(toIndentedString(processVersion)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
        sb.append("    rootProcessId: ").append(toIndentedString(rootProcessId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
