/*
 * Decompiled with CFR 0.152.
 */
package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import ext.api.centrallog.model.ProcessLogEvent;
import ext.api.centrallog.model.Severity;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class MessageEvent
extends ProcessLogEvent {
    @Valid
    private String content = null;
    @Valid
    private String description = null;
    @Valid
    private String messageKey = null;
    @Valid
    private Map<String, String> messageParams = new HashMap<String, String>();
    @Valid
    @NotNull
    private String nodeId = null;
    @Valid
    private Severity severity = null;

    public MessageEvent content(String content) {
        this.content = content;
        return this;
    }

    public void putMetadataItem(String key, Object value) {
        this.getMetadata().put(key, value);
    }

    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public MessageEvent description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MessageEvent messageKey(String messageKey) {
        this.messageKey = messageKey;
        return this;
    }

    @JsonProperty(value="messageKey")
    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public MessageEvent messageParams(Map<String, String> messageParams) {
        this.messageParams = messageParams;
        return this;
    }

    @JsonProperty(value="messageParams")
    public Map<String, String> getMessageParams() {
        return this.messageParams;
    }

    public void setMessageParams(Map<String, String> messageParams) {
        this.messageParams = messageParams;
    }

    public MessageEvent nodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @JsonProperty(value="nodeId")
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public MessageEvent severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @JsonProperty(value="severity")
    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageEvent messageEvent = (MessageEvent)o;
        return Objects.equals(this.content, messageEvent.content) && Objects.equals(this.description, messageEvent.description) && Objects.equals(this.messageKey, messageEvent.messageKey) && Objects.equals(this.messageParams, messageEvent.messageParams) && Objects.equals(this.nodeId, messageEvent.nodeId) && Objects.equals((Object)this.severity, (Object)messageEvent.severity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.description, this.messageKey, this.messageParams, this.nodeId, this.severity});
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageEvent {\n");
        sb.append("    ").append(this.toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content, true)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description, true)).append("\n");
        sb.append("    messageKey: ").append(this.toIndentedString(this.messageKey)).append("\n");
        sb.append("    messageParams: ").append(this.toIndentedString(this.messageParams)).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

