/*
 * Copyright (c) 2018, 1000kit.org, and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.tkit.rhpam.quarkus.domain.models;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * The Search Criteria for ProcessStepLog
 */
@Getter
@Setter
@ToString
public class FailedStepSearchCriteria implements Serializable {

    /**
     * The process instance id.
     */
    private Long processInstanceId;

    /**
     * The parent process instance id
     */
    private String parentProcessInstanceId;

    /**
     * The work item id.
     */
    private Long workItemId;

    /**
     * The Reference BID to the Entity.
     */
    private Long referenceBid;

    /**
     * The reference key.
     */
    private String referenceKey;

    /**
     * The process step name.
     */
    private String processStepName;

    /**
     * The parent process id.
     */
    private String processName;

    /**
     * The process step log guid.
     */
    private String processStepLogGuid;

    /**
     * The failed step status
     */
    private FailedStep.FailedStepStatus status;

    /**
     * The type of failure
     */
    private FailedStep.FailureType failureType;
}
