package org.tkit.rhpam.quarkus.messaging.model;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.ToString;

import java.util.Date;
import java.util.Map;

/**
 * The abstract process item
 * <p>
 * {@link ProcessEventItem}
 */
@Getter
@ToString
@AllArgsConstructor
public class AbstractProcessItem {

    /**
     * The process log GUID.
     */
    private String processLogGuid;

    /**
     * The execution id.
     */
    private Long executionId;

    /**
     * The timer id.
     */
    private Long timerId;

    /**
     * The work item id.
     */
    private Long workItemId;

    /**
     * The JSON body message.
     */
    @ToString.Exclude
    private String body;

    /**
     * The node type.
     */
    private NodeType nodeType;

    /**
     * The reference ID.
     */
    private Long referenceBid;

    /**
     * The reference key.
     */
    private String referenceKey;

    /**
     * The process ID.
     */
    protected String processId;

    /**
     * The process name.
     */
    protected String processName;

    /**
     * The process version.
     */
    protected String processVersion;

    /**
     * The process instance ID.
     */
    protected Long processInstanceId;

    /**
     * The execution date.
     */
    protected Date executionDate;

    /**
     * The deployment ID.
     */
    protected String deploymentId;

    /**
     * The name.
     */
    protected String name;

    /**
     * The ID.
     */
    protected Long nodeId;

    /**
     * The parent process instance ID.
     */
    protected Long parentProcessInstanceId;

    /**
     * The boundary event id if exists.
     */
    protected String boundaryEventId;

    /**
     * The process work item parameters.
     */
    @ToString.Exclude
    protected Map<String, Object> parameters;

    /**
     * Parent process instance id
     */
    protected String parentProcessId;

}
