package org.tkit.rhpam.quarkus.messaging.model;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Date;
import java.util.Map;
import java.util.Set;

/**
 * The type Process step execution.
 */
@Getter
@Setter
@ToString(onlyExplicitlyIncluded = true)
@Builder()
public class ProcessStepExecution {
    @ToString.Include
    private String executionId;

    private String correlationId;
    /**
     * The work item id.
     */
    private Long workItemId;

    /**
     * The node type.
     */
    @ToString.Include
    private NodeType nodeType;

    /**
     * The reference ID.
     */
    private String referenceId;

    /**
     * The reference key.
     */
    private String referenceKey;

    /**
     * The process ID.
     */
    @ToString.Include
    protected String processId;

    /**
     * The process name.
     */
    protected String processName;

    /**
     * The process version.
     */
    protected String processVersion;

    /**
     * The process instance ID.
     */
    @ToString.Include
    protected Long processInstanceId;

    /**
     * The execution date.
     */
    protected Date executionDate;

    /**
     * The deployment ID.
     */
    protected String deploymentId;

    /**
     * The name.
     */
    @ToString.Include
    protected String name;

    /**
     * The ID.
     */
    protected String nodeId;

    /**
     * The parent process instance ID.
     */
    protected Long parentProcessInstanceId;


    /**
     * The process work item parameters.
     */
    @ToString.Exclude
    protected Map<String, Object> parameters;

    /**
     * Returns <code>true</code> if this work item contains parameter for the
     * specified name.
     *
     * @param name name of the parameter.
     * @return <code>true</code> if this work item contains parameter for the specified name
     */
    public boolean hasParameter(String name) {
        return parameters.containsKey(name);
    }

    /**
     * Returns the value to which the specified parameter is mapped, or
     * {@code null} if this work item contains no parameter for the name.
     *
     * @param <T>  the parameter type.
     * @param name the parameter name.
     * @return the parameter value.
     */
    @SuppressWarnings("unchecked")
    public <T> T getParameter(String name) {
        return (T) parameters.get(name);
    }

    /**
     * Get all parameter names.
     *
     * @return all parameter names
     */
    public Set<String> getParameterNames() {
        return parameters.keySet();
    }

}
